/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Marshaller;
import org.jboss.xb.binding.ObjectModelProvider;
import org.xml.sax.SAXException;

public abstract class AbstractMarshaller
implements Marshaller {
    protected static final Logger log = Logger.getLogger((Class)AbstractMarshaller.class);
    protected String version = "1.0";
    protected String encoding = "UTF-8";
    protected List rootQNames = new ArrayList();
    private Map classMappings = Collections.EMPTY_MAP;
    private Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(String schemaUri, ObjectModelProvider provider, Object root, Writer writer) throws IOException, ParserConfigurationException, SAXException {
        InputStream is;
        URL url;
        try {
            url = new URL(schemaUri);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed schema URI " + schemaUri + ": " + e.getMessage());
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open input stream for schema " + schemaUri + ": " + e.getMessage());
        }
        try {
            InputStreamReader reader = new InputStreamReader(is);
            this.marshal(reader, provider, root, writer);
        }
        finally {
            is.close();
        }
    }

    public void mapClassToGlobalElement(Class cls, String localName, String namespaceUri, String schemaUrl, ObjectModelProvider provider) {
        GenericObjectModelProvider delProv = null;
        if (provider != null) {
            delProv = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        }
        ClassMapping mapping = new ClassMapping(cls, localName, null, namespaceUri, schemaUrl, delProv);
        this.addClassMapping(mapping);
    }

    public void mapClassToGlobalType(Class cls, String localName, String nsUri, String schemaUrl, ObjectModelProvider provider) {
        ClassMapping mapping = new ClassMapping(cls, null, localName, nsUri, schemaUrl, provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
        this.addClassMapping(mapping);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void mapPublicIdToSystemId(String publicId, String systemId) {
        throw new UnsupportedOperationException();
    }

    public void addRootElement(String namespaceUri, String prefix, String name) {
        this.addRootElement(new QName(namespaceUri, name, prefix));
    }

    public void addRootElement(QName qName) {
        this.rootQNames.add(qName);
    }

    public void setProperty(String name, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.props == null ? null : this.props.getProperty(name);
    }

    public abstract void declareNamespace(String var1, String var2);

    public abstract void addAttribute(String var1, String var2, String var3, String var4);

    protected boolean propertyIsTrueOrNotSet(String name) {
        String value = this.getProperty(name);
        return value == null || "true".equalsIgnoreCase(value);
    }

    protected void writeXmlVersion(Writer writer) throws IOException {
        String xmlVersion = this.getProperty("org.jboss.xml.binding.marshalling.version");
        if (xmlVersion == null || "true".equalsIgnoreCase(xmlVersion)) {
            writer.write("<?xml version=\"");
            writer.write(this.version);
            writer.write("\" encoding=\"");
            writer.write(this.encoding);
            writer.write("\"?>\n");
        }
    }

    protected ClassMapping getClassMapping(Class cls) {
        return (ClassMapping)this.classMappings.get(cls);
    }

    private void addClassMapping(ClassMapping mapping) {
        if (this.classMappings == Collections.EMPTY_MAP) {
            this.classMappings = new HashMap();
        }
        this.classMappings.put(mapping.cls, mapping);
    }

    static Object provideChildren(ObjectModelProvider provider, Object parent, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> parentClass = parent.getClass();
        String methodName = "getChildren";
        Object container = null;
        Method method = AbstractMarshaller.getProviderMethod(providerClass, methodName, new Class[]{parentClass, String.class, String.class});
        if (method != null) {
            try {
                container = method.invoke((Object)provider, parent, namespaceUri, name);
            }
            catch (Exception e) {
                log.error((Object)("Failed to invoke method " + methodName), (Throwable)e);
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return container;
    }

    static Object provideValue(ObjectModelProvider provider, Object parent, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> parentClass = parent.getClass();
        String methodName = "getElementValue";
        Object value = null;
        Method method = AbstractMarshaller.getProviderMethod(providerClass, methodName, new Class[]{parentClass, String.class, String.class});
        if (method != null) {
            try {
                value = method.invoke((Object)provider, parent, namespaceUri, name);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return value;
    }

    static Object provideAttributeValue(ObjectModelProvider provider, Object object, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> objectClass = object.getClass();
        String methodName = "getAttributeValue";
        Object value = null;
        Method method = AbstractMarshaller.getProviderMethod(providerClass, methodName, new Class[]{objectClass, String.class, String.class});
        if (method != null) {
            try {
                value = method.invoke((Object)provider, object, namespaceUri, name);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return value;
    }

    private static Method getProviderMethod(Class providerClass, String methodName, Class[] args) {
        Method method = null;
        try {
            method = providerClass.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    public static class StackImpl
    implements Stack {
        private LinkedList list = new LinkedList();

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    protected static interface Stack {
        public void clear();

        public void push(Object var1);

        public Object pop();

        public Object peek();

        public boolean isEmpty();
    }

    protected class ClassMapping {
        public final Class cls;
        public final QName elementName;
        public final QName typeName;
        public final String schemaUrl;
        public final GenericObjectModelProvider provider;

        public ClassMapping(Class cls, String elementName, String typeName, String nsUri, String schemaUrl, GenericObjectModelProvider provider) {
            this.cls = cls;
            if (elementName != null) {
                this.elementName = nsUri == null ? new QName(elementName) : new QName(nsUri, elementName);
                this.typeName = null;
            } else if (typeName != null) {
                this.elementName = null;
                this.typeName = nsUri == null ? new QName(typeName) : new QName(nsUri, typeName);
            } else {
                throw new JBossXBRuntimeException("Element or type name must not null for " + cls);
            }
            this.schemaUrl = schemaUrl;
            this.provider = provider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassMapping that = (ClassMapping)o;
            if (this.cls != null ? !this.cls.equals(that.cls) : that.cls != null) {
                return false;
            }
            if (this.elementName != null ? !this.elementName.equals(that.elementName) : that.elementName != null) {
                return false;
            }
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) {
                return false;
            }
            if (this.schemaUrl != null ? !this.schemaUrl.equals(that.schemaUrl) : that.schemaUrl != null) {
                return false;
            }
            return !(this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.elementName != null ? this.elementName.hashCode() : 0);
            result = 29 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            result = 29 * result + (this.schemaUrl != null ? this.schemaUrl.hashCode() : 0);
            result = 29 * result + (this.provider != null ? this.provider.hashCode() : 0);
            return result;
        }
    }
}

