/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jbpm.command.ExecuteNodeCommand;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.msg.MessageService;
import org.jbpm.svc.Services;

public class Node
extends GraphElement
implements Parsable {
    private static final long serialVersionUID = 1L;
    protected List leavingTransitions = null;
    transient Map leavingTransitionMap = null;
    protected Set arrivingTransitions = null;
    protected Action action = null;
    protected SuperState superState = null;
    protected boolean isAsync = false;
    public static final String[] supportedEventTypes = new String[]{"node-enter", "node-leave", "before-signal", "after-signal"};

    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public Node() {
    }

    public Node(String name) {
        super(name);
    }

    public void read(Element nodeElement, JpdlXmlReader jpdlXmlReader) {
        this.action = jpdlXmlReader.readSingleAction(nodeElement);
    }

    public void write(Element nodeElement) {
        if (this.action != null) {
            String actionName = ActionTypes.getActionName(this.action.getClass());
            Element actionElement = nodeElement.addElement(actionName);
            this.action.write(actionElement);
        }
    }

    public List getLeavingTransitions() {
        return this.leavingTransitions;
    }

    public Map getLeavingTransitionsMap() {
        if (this.leavingTransitionMap == null && this.leavingTransitions != null) {
            this.leavingTransitionMap = new HashMap();
            ListIterator iter = this.leavingTransitions.listIterator(this.leavingTransitions.size());
            while (iter.hasPrevious()) {
                Transition leavingTransition = (Transition)iter.previous();
                this.leavingTransitionMap.put(leavingTransition.getName(), leavingTransition);
            }
        }
        return this.leavingTransitionMap;
    }

    public Transition addLeavingTransition(Transition leavingTransition) {
        if (leavingTransition == null) {
            throw new IllegalArgumentException("can't add a null leaving transition to an node");
        }
        if (this.leavingTransitions == null) {
            this.leavingTransitions = new ArrayList();
        }
        this.leavingTransitions.add(leavingTransition);
        leavingTransition.from = this;
        this.leavingTransitionMap = null;
        return leavingTransition;
    }

    public void removeLeavingTransition(Transition leavingTransition) {
        if (leavingTransition == null) {
            throw new IllegalArgumentException("can't remove a null leavingTransition from an node");
        }
        if (this.leavingTransitions != null && this.leavingTransitions.remove(leavingTransition)) {
            leavingTransition.from = null;
            this.leavingTransitionMap = null;
        }
    }

    public boolean hasLeavingTransition(String transitionName) {
        if (this.leavingTransitions == null) {
            return false;
        }
        return this.getLeavingTransitionsMap().containsKey(transitionName);
    }

    public Transition getLeavingTransition(String transitionName) {
        Transition transition = null;
        if (this.leavingTransitions != null) {
            transition = (Transition)this.getLeavingTransitionsMap().get(transitionName);
        }
        if (transition == null && this.superState != null) {
            transition = this.superState.getLeavingTransition(transitionName);
        }
        return transition;
    }

    public boolean hasNoLeavingTransitions() {
        return !(this.leavingTransitions != null && this.leavingTransitions.size() != 0 || this.superState != null && !this.superState.hasNoLeavingTransitions());
    }

    public String generateNextLeavingTransitionName() {
        String name = null;
        if (this.leavingTransitions != null) {
            if (!this.containsName(this.leavingTransitions, null)) {
                name = null;
            } else {
                int n = 1;
                while (this.containsName(this.leavingTransitions, Integer.toString(n))) {
                    ++n;
                }
                name = Integer.toString(n);
            }
        }
        return name;
    }

    boolean containsName(List leavingTransitions, String name) {
        Iterator iter = leavingTransitions.iterator();
        while (iter.hasNext()) {
            Transition transition = (Transition)iter.next();
            if (name == null && transition.getName() == null) {
                return true;
            }
            if (name == null || !name.equals(transition.getName())) continue;
            return true;
        }
        return false;
    }

    public Transition getDefaultLeavingTransition() {
        Transition defaultTransition = null;
        if (this.leavingTransitions != null && this.leavingTransitions.size() > 0) {
            defaultTransition = (Transition)this.leavingTransitions.get(0);
        } else if (this.superState != null) {
            defaultTransition = this.superState.getDefaultLeavingTransition();
        }
        return defaultTransition;
    }

    public void reorderLeavingTransition(int oldIndex, int newIndex) {
        if (this.leavingTransitions != null && Math.min(oldIndex, newIndex) >= 0 && Math.max(oldIndex, newIndex) < this.leavingTransitions.size()) {
            Object o = this.leavingTransitions.remove(oldIndex);
            this.leavingTransitions.add(newIndex, o);
        }
    }

    public List getLeavingTransitionsList() {
        return this.leavingTransitions;
    }

    public Set getArrivingTransitions() {
        return this.arrivingTransitions;
    }

    public Transition addArrivingTransition(Transition arrivingTransition) {
        if (arrivingTransition == null) {
            throw new IllegalArgumentException("can't add a null arrivingTransition to a node");
        }
        if (this.arrivingTransitions == null) {
            this.arrivingTransitions = new HashSet();
        }
        this.arrivingTransitions.add(arrivingTransition);
        arrivingTransition.to = this;
        return arrivingTransition;
    }

    public void removeArrivingTransition(Transition arrivingTransition) {
        if (arrivingTransition == null) {
            throw new IllegalArgumentException("can't remove a null arrivingTransition from a node");
        }
        if (this.arrivingTransitions != null && this.arrivingTransitions.remove(arrivingTransition)) {
            arrivingTransition.to = null;
        }
    }

    public GraphElement getParent() {
        GraphElement parent = this.processDefinition;
        if (this.superState != null) {
            parent = this.superState;
        }
        return parent;
    }

    public void enter(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        token.setNode(this);
        this.fireEvent("node-enter", executionContext);
        token.setNodeEnter(new Date());
        executionContext.setTransition(null);
        executionContext.setTransitionSource(null);
        if (this.isAsync) {
            ExecuteNodeCommand continuationMsg = new ExecuteNodeCommand(this, executionContext.getToken());
            MessageService messageService = (MessageService)Services.getCurrentService("message");
            messageService.send(continuationMsg);
        } else {
            this.execute(executionContext);
        }
    }

    public void execute(ExecutionContext executionContext) {
        if (this.action != null) {
            try {
                this.action.execute(executionContext);
            }
            catch (Throwable exception) {
                this.raiseException(exception, executionContext);
            }
        } else {
            this.leave(executionContext);
        }
    }

    public void leave(ExecutionContext executionContext) {
        this.leave(executionContext, this.getDefaultLeavingTransition());
    }

    public void leave(ExecutionContext executionContext, String transitionName) {
        Transition transition = this.getLeavingTransition(transitionName);
        if (transition == null) {
            throw new RuntimeException("transition '" + transitionName + "' is not a leaving transition of node '" + this + "'");
        }
        this.leave(executionContext, transition);
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        if (transition == null) {
            throw new RuntimeException("can't leave node '" + this + "' without leaving transition");
        }
        Token token = executionContext.getToken();
        token.setNode(this);
        executionContext.setTransition(transition);
        this.fireEvent("node-leave", executionContext);
        if (token.getNodeEnter() != null) {
            token.addLog(new NodeLog(this, token.getNodeEnter(), new Date()));
        }
        executionContext.setTransitionSource(this);
        transition.take(executionContext);
    }

    public ProcessDefinition getProcessDefinition() {
        ProcessDefinition pd = this.processDefinition;
        if (this.superState != null) {
            pd = this.superState.getProcessDefinition();
        }
        return pd;
    }

    public void setName(String name) {
        if (this.isDifferent(this.name, name)) {
            String oldName = this.name;
            if (this.superState != null) {
                if (this.superState.hasNode(name)) {
                    throw new IllegalArgumentException("couldn't set name '" + name + "' on node '" + this + "'cause the superState of this node has already another child node with the same name");
                }
                Map nodes = this.superState.getNodesMap();
                nodes.remove(oldName);
                nodes.put(name, this);
            } else if (this.processDefinition != null) {
                if (this.processDefinition.hasNode(name)) {
                    throw new IllegalArgumentException("couldn't set name '" + name + "' on node '" + this + "'cause the process definition of this node has already another node with the same name");
                }
                Map nodeMap = this.processDefinition.getNodesMap();
                nodeMap.remove(oldName);
                nodeMap.put(name, this);
            }
            this.name = name;
        }
    }

    boolean isDifferent(String name1, String name2) {
        if (name1 != null && name1.equals(name2)) {
            return false;
        }
        return name1 != null || name2 != null;
    }

    public String getFullyQualifiedName() {
        String fullyQualifiedName = this.name;
        if (this.superState != null) {
            fullyQualifiedName = this.superState.getFullyQualifiedName() + "/" + this.name;
        }
        return fullyQualifiedName;
    }

    public SuperState getSuperState() {
        return this.superState;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }
}

