/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.Services;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    static ObjectFactory defaultObjectFactory = null;
    static Map instances = new HashMap();
    ObjectFactory objectFactory = null;
    private static Log log = LogFactory.getLog((Class)JbpmConfiguration.class);

    static void reset() {
        defaultObjectFactory = null;
        instances = new HashMap();
    }

    public JbpmConfiguration(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public static JbpmConfiguration getInstance() {
        return JbpmConfiguration.getInstance(null);
    }

    public static synchronized JbpmConfiguration getInstance(String resource) {
        JbpmConfiguration instance = (JbpmConfiguration)instances.get(resource);
        if (instance == null) {
            if (defaultObjectFactory != null) {
                log.debug((Object)("creating jbpm configuration from given default object factory '" + defaultObjectFactory + "'"));
                instance = new JbpmConfiguration(defaultObjectFactory);
            } else {
                InputStream jbpmCfgXmlStream = null;
                if (resource != null) {
                    log.info((Object)("using jbpm configuration resource '" + resource + "'"));
                    jbpmCfgXmlStream = ClassLoaderUtil.getStream(resource);
                } else {
                    jbpmCfgXmlStream = ClassLoaderUtil.getStream("jbpm.cfg.xml");
                    if (jbpmCfgXmlStream == null) {
                        log.info((Object)"using default jbpm configuration with minimal services enabled.  to enable persistence services, provide a jbpm.cfg.xml on the root of the classpath.  see userguide, chapter 'Configuration'");
                        jbpmCfgXmlStream = ClassLoaderUtil.getStream("org/jbpm/default.jbpm.cfg.xml");
                    } else {
                        log.info((Object)"using jbpm configuration resource 'jbpm.cfg.xml'");
                    }
                }
                try {
                    instance = JbpmConfiguration.parseInputStream(jbpmCfgXmlStream);
                }
                catch (RuntimeException e) {
                    throw new JbpmException("couldn't parse jbpm configuration from resource '" + resource + "'", e);
                }
            }
            instances.put(resource, instance);
        }
        return instance;
    }

    public static JbpmConfiguration parseXmlString(String xml) {
        ObjectFactoryImpl objectFactory = ObjectFactoryParser.parseXmlString(xml);
        log.debug((Object)"creating jbpm configuration from xml string");
        return new JbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseInputStream(InputStream inputStream) {
        ObjectFactoryImpl objectFactory = ObjectFactoryParser.parseInputStream(inputStream);
        log.debug((Object)"creating jbpm configuration from input stream");
        return new JbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseResource(String resource) {
        ObjectFactoryImpl objectFactory = ObjectFactoryParser.parseResource(resource);
        log.debug((Object)("creating jbpm configuration from resource '" + resource + "'"));
        return new JbpmConfiguration(objectFactory);
    }

    public JbpmContext createJbpmContext() {
        return this.createJbpmContext("default.jbpm.context");
    }

    public JbpmContext createJbpmContext(String name) {
        JbpmContext jbpmContext = (JbpmContext)this.objectFactory.createObject(name);
        jbpmContext.jbpmConfiguration = this;
        return jbpmContext;
    }

    public ServiceFactory getServiceFactory(String serviceName) {
        return this.getServiceFactory(serviceName, "default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFactory getServiceFactory(String serviceName, String jbpmContextName) {
        ServiceFactory serviceFactory = null;
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            serviceFactory = jbpmContext.getServices().getServiceFactory(serviceName);
        }
        finally {
            jbpmContext.close();
        }
        return serviceFactory;
    }

    public void createSchema() {
        this.createSchema("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Services services = jbpmContext.getServices();
            DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)services.getServiceFactory("persistence");
            persistenceServiceFactory.createSchema();
        }
        finally {
            jbpmContext.close();
        }
    }

    public void dropSchema() {
        this.dropSchema("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Services services = jbpmContext.getServices();
            DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)services.getServiceFactory("persistence");
            persistenceServiceFactory.dropSchema();
        }
        finally {
            jbpmContext.close();
        }
    }

    public static abstract class Configs {
        static ObjectFactory getObjectFactory() {
            ObjectFactory objectFactory = null;
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            objectFactory = jbpmContext != null ? jbpmContext.objectFactory : JbpmConfiguration.getInstance().objectFactory;
            return objectFactory;
        }

        public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
            defaultObjectFactory = objectFactory;
        }

        public static boolean hasObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.hasObject(name);
        }

        public static Object getObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.createObject(name);
        }

        public static String getString(String name) {
            return (String)Configs.getObject(name);
        }

        public static long getLong(String name) {
            return (Long)Configs.getObject(name);
        }

        public static boolean getBoolean(String name) {
            return (Boolean)Configs.getObject(name);
        }
    }
}

