/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.rmi.MarshalException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.ServerAddress;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class SocketClientInvoker
extends RemoteClientInvoker {
    private InetAddress addr;
    private int port;
    public static final String TCP_NODELAY_FLAG = "enableTcpNoDelay";
    public static final String MAX_POOL_SIZE_FLAG = "clientMaxPoolSize";
    public static final String SO_TIMEOUT_FLAG = "socketTimeout";
    public static final String CLIENT_SOCKET_CLASS_FLAG = "clientSocketClass";
    public static final int SO_TIMEOUT_DEFAULT = 1800000;
    public static final boolean TCP_NODELAY_DEFAULT = false;
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    protected boolean enableTcpNoDelay = false;
    protected int timeout = 1800000;
    protected String clientSocketClassName = (class$org$jboss$remoting$transport$socket$ClientSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ClientSocketWrapper = SocketClientInvoker.class$("org.jboss.remoting.transport.socket.ClientSocketWrapper")) : class$org$jboss$remoting$transport$socket$ClientSocketWrapper).getName();
    private Constructor clientSocketConstructor = null;
    public static final int MAX_RETRIES = 3;
    public static long usedPooled = 0L;
    protected int numberOfRetries = 3;
    protected LinkedList pool = null;
    protected ServerAddress address;
    protected HashMap connectionPools = new HashMap();
    protected int maxPoolSize = 10;
    static int counter = 0;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ClientSocketWrapper;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    public SocketClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
        try {
            this.setup();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    protected void setup() throws Exception {
        this.addr = InetAddress.getByName(this.locator.getHost());
        this.port = this.locator.getPort();
        this.configureParameters();
        this.address = new ServerAddress(this.addr.getHostAddress(), this.port, this.enableTcpNoDelay, this.timeout);
    }

    protected void configureParameters() {
        Map params = this.locator.getParameters();
        if (params != null) {
            String value;
            Object val = params.get(TCP_NODELAY_FLAG);
            if (val != null) {
                try {
                    boolean bVal;
                    this.enableTcpNoDelay = bVal = Boolean.valueOf((String)val).booleanValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::enableTcpNoDelay to: " + this.enableTcpNoDelay));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert enableTcpNoDelay value of " + val + " to a boolean value."));
                }
            }
            if ((val = params.get(MAX_POOL_SIZE_FLAG)) != null) {
                try {
                    int nVal;
                    this.maxPoolSize = nVal = Integer.valueOf((String)val).intValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::maxPoolSize to: " + this.maxPoolSize));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert clientMaxPoolSize value of " + val + " to a int value."));
                }
            }
            if ((val = params.get(SO_TIMEOUT_FLAG)) != null) {
                try {
                    int nVal;
                    this.timeout = nVal = Integer.valueOf((String)val).intValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::timeout to: " + this.timeout));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert socketTimeout value of " + val + " to a int value."));
                }
            }
            if ((val = params.get(CLIENT_SOCKET_CLASS_FLAG)) != null && (value = (String)val).length() > 0) {
                this.clientSocketClassName = value;
                this.log.debug((Object)("Setting ClientSocket class name to: " + this.clientSocketClassName));
            }
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    protected synchronized void handleConnect() throws ConnectionFailedException {
        this.initPool();
    }

    protected synchronized void handleDisconnect() {
        this.clearPools();
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        Object response = null;
        long start = System.currentTimeMillis();
        SocketWrapper socketWrapper = null;
        try {
            socketWrapper = this.getConnection();
        }
        catch (Exception e) {
            throw new CannotConnectException("Can not get connection to server.  Problem establishing socket connection.", e);
        }
        long end = System.currentTimeMillis() - start;
        getSocketTime += end;
        try {
            marshaller.write(invocation, socketWrapper.getOutputStream());
            end = System.currentTimeMillis() - start;
            writeTime += end;
            start = System.currentTimeMillis();
            response = unmarshaller.read(socketWrapper.getInputStream(), null);
            end = System.currentTimeMillis() - start;
            readTime += end;
        }
        catch (Exception ex) {
            try {
                socketWrapper.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.log.error((Object)"Got marshalling exception, exiting", (Throwable)ex);
            if (ex instanceof ClassNotFoundException) {
                this.log.error((Object)"Error loading classes from remote call result.", (Throwable)ex);
                throw (ClassNotFoundException)ex;
            }
            if (ex instanceof SocketTimeoutException) {
                throw new MarshalException("Socket timed out.  Waited " + socketWrapper.getTimeout() + " milliseconds for response while calling on " + this.getLocator(), ex);
            }
            throw new MarshalException("Failed to communicate.  Problem during marshalling/unmarshalling", ex);
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxPoolSize) {
                this.pool.add(socketWrapper);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Pool was already full, than we will close the connection");
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Response: " + response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPool(ServerAddress sa) {
        try {
            LinkedList thepool = (LinkedList)this.connectionPools.get(sa);
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    SocketWrapper socketWrapper = (SocketWrapper)thepool.removeFirst();
                    try {
                        socketWrapper.close();
                        socketWrapper = null;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPools() {
        HashMap hashMap = this.connectionPools;
        synchronized (hashMap) {
            Iterator it = this.connectionPools.keySet().iterator();
            while (it.hasNext()) {
                ServerAddress sa = (ServerAddress)it.next();
                this.clearPool(sa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        HashMap hashMap = this.connectionPools;
        synchronized (hashMap) {
            this.pool = (LinkedList)this.connectionPools.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                this.connectionPools.put(this.address, this.pool);
            }
        }
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries < 1 ? 3 : numberOfRetries;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketWrapper getConnection() throws Exception {
        Object failed = null;
        Socket socket = null;
        for (int i = 0; i < this.numberOfRetries; ++i) {
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                SocketWrapper pooled;
                if (this.pool.size() > 0 && (pooled = this.getPooledConnection()) != null) {
                    ++usedPooled;
                    return pooled;
                }
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Creating socket number " + counter++));
                }
                socket = this.createSocket(this.address.address, this.address.port);
                break;
            }
            catch (Exception ex) {
                if (i + 1 >= 3) {
                    throw ex;
                }
                Thread.sleep(1L);
                continue;
            }
        }
        socket.setTcpNoDelay(this.address.enableTcpNoDelay);
        return this.createClientSocket(socket, this.address.timeout, this.getLocator().getParameters());
    }

    protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.clientSocketConstructor == null) {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Class<?> cl = classLoader.loadClass(this.clientSocketClassName);
            try {
                this.clientSocketConstructor = cl.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = SocketClientInvoker.class$("java.net.Socket")) : class$java$net$Socket, class$java$util$Map == null ? (class$java$util$Map = SocketClientInvoker.class$("java.util.Map")) : class$java$util$Map, class$java$lang$Integer == null ? (class$java$lang$Integer = SocketClientInvoker.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            catch (NoSuchMethodException e) {
                this.clientSocketConstructor = cl.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = SocketClientInvoker.class$("java.net.Socket")) : class$java$net$Socket);
            }
        }
        SocketWrapper clientSocketWrapper = null;
        if (this.clientSocketConstructor.getParameterTypes().length == 3) {
            clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket, metadata, new Integer(timeout));
        } else {
            clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket);
            clientSocketWrapper.setTimeout(timeout);
        }
        return clientSocketWrapper;
    }

    protected Socket createSocket(String address, int port) throws IOException {
        return new Socket(address, port);
    }

    protected SocketWrapper getPooledConnection() {
        SocketWrapper socketWrapper = null;
        while (this.pool.size() > 0) {
            socketWrapper = (SocketWrapper)this.pool.removeFirst();
            try {
                if (socketWrapper == null) continue;
                socketWrapper.checkConnection();
                return socketWrapper;
            }
            catch (Exception ex) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Couldn't reuse connection from pool");
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

