/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingDataInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class MasterServerSocket
extends ServerSocket
implements Serializable {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$MasterServerSocket == null ? (class$org$jboss$remoting$transport$multiplex$MasterServerSocket = MasterServerSocket.class$("org.jboss.remoting.transport.multiplex.MasterServerSocket")) : class$org$jboss$remoting$transport$multiplex$MasterServerSocket));
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MasterServerSocket;

    public MasterServerSocket() throws IOException {
    }

    public MasterServerSocket(int port) throws IOException {
        super(port);
    }

    public MasterServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public MasterServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        MultiplexingDataInputStream mdis;
        SocketId clientPort;
        Protocol protocol;
        MultiplexingManager manager;
        int timeout;
        long start = System.currentTimeMillis();
        int savedTimeout = timeout = this.getSoTimeout();
        int timeLeft = 0;
        Socket socket = null;
        while (true) {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("Accept timed out");
            }
            this.setSoTimeout(timeLeft);
            try {
                socket = super.accept();
            }
            finally {
                this.setSoTimeout(savedTimeout);
            }
            manager = MultiplexingManager.getaManager(socket);
            MultiplexingDataInputStream is = null;
            protocol = null;
            clientPort = null;
            try {
                is = new MultiplexingDataInputStream(manager.getAnInputStream(SocketId.SERVER_SOCKET_ID, null));
                protocol = manager.getProtocol();
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                clientPort = protocol.acceptConnect(is, timeLeft);
            }
            catch (IOException e) {
                log.error((Object)"i/o exception in MasterServerSocket.accept()");
                manager.decrementReferences();
                throw e;
            }
            log.debug((Object)("accept(): clientPort:  " + clientPort.getPort()));
            if (clientPort.getPort() >= 0) break;
            MultiplexingOutputStream mos = new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_CONNECT_ID);
            DataOutputStream os = new DataOutputStream(mos);
            manager.setCreatedForRemoteServerSocket();
            mdis = null;
            try {
                protocol.answerConnect(os, -3);
                MultiplexingInputStream mis = manager.getAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID, null);
                mdis = new MultiplexingDataInputStream(mis);
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                protocol.getConnectVerification(mdis, timeLeft);
            }
            catch (IOException e) {
                log.error((Object)"unable to respond to connect request");
                manager.decrementReferences();
                if (e instanceof SocketTimeoutException) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                throw e;
            }
        }
        VirtualSocket virtualSocket = null;
        try {
            virtualSocket = new VirtualSocket(manager, clientPort);
        }
        catch (IOException e) {
            manager.decrementReferences();
            throw e;
        }
        int localPort = virtualSocket.getLocalVirtualPort();
        try {
            protocol.answerConnect(new DataOutputStream(virtualSocket.getOutputStream()), localPort);
        }
        catch (IOException e) {
            log.error((Object)"unable to respond to connect request");
            virtualSocket.close();
            throw e;
        }
        mdis = null;
        try {
            mdis = new MultiplexingDataInputStream((MultiplexingInputStream)virtualSocket.getInputStream());
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("Accept timed out");
            }
            protocol.getConnectVerification(mdis, timeLeft);
        }
        catch (IOException e) {
            log.error((Object)"unable to get confirmation that connect was successful");
            virtualSocket.close();
            if (e instanceof SocketTimeoutException) {
                throw new SocketTimeoutException("Accept timed out");
            }
            throw e;
        }
        return virtualSocket;
    }

    public void close() throws IOException {
        log.debug((Object)"MasterServerSocket: closing");
        super.close();
    }

    public String toString() {
        if (!this.isBound()) {
            return "MasterServerSocket[unbound]";
        }
        return "MasterServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    public int acceptServerSocketConnection() throws IOException {
        int timeout;
        long start = System.currentTimeMillis();
        int savedTimeout = timeout = this.getSoTimeout();
        int timeLeft = 0;
        Socket socket = super.accept();
        MultiplexingManager manager = MultiplexingManager.getaManager(socket);
        MultiplexingDataInputStream is = null;
        Protocol protocol = null;
        SocketId clientPort = null;
        try {
            is = new MultiplexingDataInputStream(manager.getAnInputStream(SocketId.SERVER_SOCKET_ID, null));
            protocol = manager.getProtocol();
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("Accept timed out");
            }
            clientPort = protocol.acceptConnect(is, timeLeft);
        }
        catch (IOException e) {
            log.error((Object)"i/o exception in MasterServerSocket.acceptServerSocketConnection()", (Throwable)e);
            manager.decrementReferences();
            if (e instanceof SocketTimeoutException) {
                throw new SocketTimeoutException("Accept timed out");
            }
            throw e;
        }
        if (clientPort.getPort() != -2) {
            manager.decrementReferences();
            String message = "received connect request not from a VirtualServerSocket";
            log.error((Object)message);
            throw new IOException(message);
        }
        DataOutputStream os = new DataOutputStream(new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_CONNECT_ID));
        manager.setCreatedForRemoteServerSocket();
        try {
            protocol.answerConnect(os, -3);
            MultiplexingInputStream mis = manager.getAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID, null);
            MultiplexingDataInputStream mdis = new MultiplexingDataInputStream(mis);
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("Accept timed out");
            }
            protocol.getConnectVerification(mdis, timeLeft);
        }
        catch (IOException e) {
            log.error((Object)"unable to respond to connect request");
            manager.decrementReferences();
            throw e;
        }
        return manager.getSocket().getLocalPort();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

