/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

public class MultiplexInvokerClient {
    private Client client;
    private PerformanceCallbackHandler handler;
    private Connector connector;
    private InvokerLocator locator;

    public void init() {
        try {
            String locatorURI = "multiplex://localhost:9090/?bindHost=localhost&bindPort=8080";
            InvokerLocator locator = new InvokerLocator(locatorURI);
            this.client = new Client(locator, "sample");
            this.client.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private InvokerLocator initServer() throws Exception {
        this.connector = new Connector();
        String locatorURI = "multiplex://localhost:8080/?connectHost=localhost&connectPort=9090";
        InvokerLocator locator = new InvokerLocator(locatorURI);
        this.connector.setInvokerLocator(locator.getLocatorURI());
        this.connector.create();
        this.connector.start();
        return locator;
    }

    public void setUp() throws Exception {
        this.init();
        this.locator = this.initServer();
    }

    public void tearDown() throws Throwable {
        while (!this.handler.gotCallback) {
            Thread.sleep(1000L);
        }
        this.client.removeListener(this.handler);
        if (this.connector != null) {
            this.connector.stop();
            this.connector.destroy();
            this.connector = null;
        }
        this.locator = null;
        if (this.client != null) {
            this.client.disconnect();
            this.client = null;
        }
    }

    public void makeClientCall() throws Throwable {
        this.handler = new PerformanceCallbackHandler();
        this.client.addListener(this.handler, this.locator, this.client.getSessionId());
        Object answer = this.client.invoke(new Integer(17));
        System.out.println("invocation returns: " + (Integer)answer);
    }

    public static void main(String[] args) {
        MultiplexInvokerClient test = new MultiplexInvokerClient();
        try {
            test.setUp();
            test.makeClientCall();
            test.tearDown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static class PerformanceCallbackHandler
    implements InvokerCallbackHandler {
        boolean gotCallback;

        public void handleCallback(Callback callback) throws HandleCallbackException {
            Object ret = callback.getCallbackObject();
            this.gotCallback = true;
            System.out.println("callback value: " + ret);
        }

        public boolean gotCallback() {
            return this.gotCallback;
        }
    }
}

