/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.container;

import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.ClientAuthConfig;
import javax.security.auth.container.ClientAuthContext;
import javax.security.auth.container.MessageLayer;
import javax.security.auth.container.ServerAuthConfig;
import javax.security.auth.container.ServerAuthContext;

public abstract class AuthContextFactory {
    private static AuthContextFactory _factory = null;
    private static final String FACTORY_PROP = "authcontextfactory.provider";
    private static final String DEFAULT_FACTORY_NAME = "org.jboss.security.auth.container.JBossAuthContextFactory";

    public abstract ClientAuthContext getAuthContext(ClientAuthConfig var1, String var2) throws AuthException;

    public abstract ServerAuthContext getAuthContext(ServerAuthConfig var1, String var2) throws AuthException;

    public abstract ClientAuthConfig getClientAuthConfig(MessageLayer var1, URI var2, CallbackHandler var3) throws AuthException;

    public static AuthContextFactory getFactory() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (_factory == null) {
            String factoryName = null;
            Class clazz = null;
            try {
                LoadAction action = new LoadAction();
                try {
                    clazz = (Class)AccessController.doPrivileged(action);
                    factoryName = action.getName();
                }
                catch (PrivilegedActionException ex) {
                    factoryName = action.getName();
                    Exception e = ex.getException();
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    throw new IllegalStateException("Failure during load of class: " + action.getName() + e);
                }
                _factory = (AuthContextFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "Failed to find PolicyConfigurationFactory : " + factoryName;
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
            catch (IllegalAccessException e) {
                String msg = "Unable to access class : " + factoryName;
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
            catch (InstantiationException e) {
                String msg = "Failed to create instance of: " + factoryName;
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
            catch (ClassCastException e) {
                StringBuffer msg = new StringBuffer(factoryName + " Is not a PolicyConfigurationFactory, ");
                msg.append("PCF.class.CL: " + AuthContextFactory.class.getClassLoader());
                msg.append("\nPCF.class.CS: " + AuthContextFactory.class.getProtectionDomain().getCodeSource());
                msg.append("\nPCF.class.hash: " + System.identityHashCode(AuthContextFactory.class));
                msg.append("\nclazz.CL: " + clazz.getClassLoader());
                msg.append("\nclazz.CS: " + clazz.getProtectionDomain().getCodeSource());
                msg.append("\nclazz.super.CL: " + clazz.getSuperclass().getClassLoader());
                msg.append("\nclazz.super.CS: " + clazz.getSuperclass().getProtectionDomain().getCodeSource());
                msg.append("\nclazz.super.hash: " + System.identityHashCode(clazz.getSuperclass()));
                ClassCastException cce = new ClassCastException(msg.toString());
                cce.initCause(e);
                throw cce;
            }
        }
        return _factory;
    }

    public abstract ServerAuthConfig getServerAuthConfig(MessageLayer var1, URI var2, CallbackHandler var3) throws AuthException;

    public static void setFactory(AuthContextFactory factory) {
        _factory = factory;
    }

    private static class LoadAction
    implements PrivilegedExceptionAction {
        private String name;

        private LoadAction() {
        }

        public String getName() {
            return this.name;
        }

        public Object run() throws Exception {
            this.name = System.getProperty(AuthContextFactory.FACTORY_PROP);
            if (this.name == null) {
                this.name = AuthContextFactory.DEFAULT_FACTORY_NAME;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(this.name);
            return factoryClass;
        }
    }
}

