package com.corejsf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import javax.faces.bean.ManagedBean; 
   // lub import javax.inject.Named;
import javax.faces.bean.SessionScoped; 
   // lub import javax.enterprise.context.SessionScoped;

@ManagedBean(name="bb") // lub @Named("bb")
@SessionScoped
public class BackingBean implements Serializable {
   private String country = "USA";
   private String state = "Kalifornia";
   private static Map<String, String[]> states;

   public String getCountry() { return country; }
   public void setCountry(String newValue) { country = newValue; }

   public String getState() { return state; }
   public void setState(String newValue) { state = newValue; }

   public Map<String, String[]> getStates() { return states; }

   public String[] getStatesForCountry() { return (String[]) states.get(country); }

   static {
      states = new HashMap<String, String[]>();
      states.put("USA", 
         new String[] {
            "Alabama", "Alaska", "Arizona", "Arkansas", "Kalifornia",
            "Kolorado", "Connecticut", "Delaware", "Floryda", "Georgia",
            "Hawaje", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas",
            "Kentucky", "Louizjana", "Maine", "Maryland", "Massachusetts",
            "Michigan", "Minnesota", "Missisippi", "Missouri", "Montana",
            "Nebraska", "Nevada", "New Hampshire", "New Jersey", "Nowy Meksyk",
            "Nowy Jork", "Karolina Pnocna", "Dakota Pnocna", "Ohio", "Oklahoma",
            "Oregon", "Pensylwania", "Rhode Island", "Karolina Poudniowa",
            "Dakota Poudniowa", "Tennessee", "Teksas", "Utah", "Vermont",
            "Wirginia", "Waszyngton", "Wirginia Zachownia", "Wisconsin", "Wyoming"
         });

      states.put("Kanada",
         new String[] { 
            "Alberta", "Kolumbia Brytyjska", "Manitoba", "Nowy Brunszwik",
            "Nowa Fundlandia i Labrador", "Terytoria Pnocno-Zachodnie",
            "Nowa Szkocja", "Nunavut", "Ontario", "Wyspa Ksicia Edwarda",
            "Quebec", "Saskatchewan", "Yukon"
         });
   }
}