package com.corejsf;

import java.io.Serializable;
import java.util.Comparator;

import javax.faces.bean.ManagedBean; 
   // lub import javax.inject.Named;
import javax.faces.bean.SessionScoped; 
   // lub import javax.enterprise.context.SessionScoped;
import javax.faces.model.DataModel;
import javax.faces.model.ArrayDataModel;

@ManagedBean // lub @Named
@SessionScoped
public class TableData implements Serializable {
   private SortFilterModel<Name> filterModel;
   private static final Name[] names = {
      new Name("Anna", "Kowalska"),
      new Name("Jan", "Winnicki"),
      new Name("Mariusz", "Rachwa"),
      new Name("Jan", "Waligra")
   };

   public TableData() {
      filterModel = new SortFilterModel<Name>(new ArrayDataModel<Name>(names));
   }
   public DataModel<Name> getNames() {
      return filterModel;
   }

   public String sortByFirst() {
      filterModel.sortBy(new Comparator<Name>() {
         public int compare(Name n1, Name n2) {
            return n1.getFirst().compareTo(n2.getFirst());
         }  
      });
      return null;
   }
   
   public String sortByLast() {
      filterModel.sortBy(new Comparator<Name>() {
         public int compare(Name n1, Name n2) {
            return n1.getLast().compareTo(n2.getLast());
         }  
      });
      return null;
   }
}