package com.corejsf;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.faces.bean.ManagedBean; 
   // lub import javax.inject.Named;
import javax.faces.bean.SessionScoped; 
   // lub import javax.enterprise.context.SessionScoped;

@ManagedBean // lub @Named
@SessionScoped
public class QuizBean implements Serializable {
   private int currentProblem;
   private int tries;
   private String response = "";
   private String correctAnswer;

   // Poniej zakodowano problemy na stae. W rzeczywistej aplikacji
   // najprawdopodobniej odczytywalibymy je z bazy danych.
   private ArrayList<Problem> problems = new ArrayList<Problem>(Arrays.asList(
      new Problem(
         "Jaki slogan reklamowa programowanie w Javie? Write once, ...",
         "run anywhere"),
      new Problem(
         "Jak wygldaj 4 pierwsze bajty kadego pliku klasy (szesnastkowo)?",
         "CAFEBABE"),
      new Problem(
         "Co zostanie wywietlone przez to wyraenie? System.out.println(1+\"2\");",
         "12"),
      new Problem(
         "Ktre sowo kluczowe Javy suy do definiowania podklasy?",
         "extends"),
      new Problem(
         "Jak brzmiaa oryginalna nazwa jzyka programowania Java?",
         "Oak"),
      new Problem(
         "Ktra klasa pakietu java.util opisuje punkt w czasie?",
         "Date")));

   private int[] scores = new int[problems.size()];

   public String getQuestion() { 
      return problems.get(currentProblem).getQuestion();
   }

   public String getAnswer() { return correctAnswer; }

   public int getScore() {
      int score = 0;
      for (int s : scores) score += s; 
      return score;
   }

   public String getResponse() { return response; }
   public void setResponse(String newValue) { response = newValue; }

   public int getCurrentProblem() { return currentProblem; }
   public void setCurrentProblem(int newValue) { currentProblem = newValue; }

   public String getSkipOutcome() {
      if (currentProblem < problems.size() - 1) return "index";
      else return "done";
   }

   public String answerAction() {
      tries++;
      if (problems.get(currentProblem).isCorrect(response)) {
         scores[currentProblem] = 1;
         nextProblem();
         if (currentProblem == problems.size()) return "done";
         else return "success";
      }
      else {
         scores[currentProblem] = 0;            
         if (tries == 1) return "again";
         else {
            nextProblem();
            if (currentProblem == problems.size()) return "done";
            else return "failure";
         }
      }
   }

   public String startOverAction() {
      Collections.shuffle(problems);
      currentProblem = 0;
      for (int i = 0; i < scores.length; i++)
         scores[i] = 0;
      tries = 0;
      response = "";
      return "startOver";
   }

   private void nextProblem() {
      correctAnswer = problems.get(currentProblem).getAnswer();
      currentProblem++;
      tries = 0;
      response = "";
   }
}