package com.devchronicles.singleton;

public class MySingleton5 {

	private volatile MySingleton5 instance;

	private MySingleton5() {
	}

	public MySingleton5 getInstance() {
		if (instance == null) { // 1
			synchronized (MySingleton5.class) {
				if (instance == null) { // 2
					instance = new MySingleton5();
				}
			}
		}
		return instance;
	}
}
