package com.devchronicles.timer;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timer;
import javax.ejb.TimerService;


@Singleton
@Startup
public class AllTimers {
	@Resource
	TimerService timerService;

	@PostConstruct
	public void manageTimer() {
		Collection<Timer> timers = timerService.getAllTimers();
		for (Timer t : timers) {
			System.out.println("Informacje czasomierza: " + t.getInfo());
			System.out.println("Pozostay czas: " + t.getTimeRemaining());
			t.cancel();
		}
	}
}