/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pl.helion.jeeweb.przychodnie.controllers;

import java.util.List;
import javax.faces.event.ActionEvent;
import javax.annotation.PreDestroy;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.persistence.EntityManager;
import pl.helion.jeeweb.przychodnie.config.DBManager;
import pl.helion.jeeweb.przychodnie.entity.Lekarz;
import pl.helion.jeeweb.przychodnie.entity.Pacjent;

/**
 *
 * @author k
 */
public class PacjentBean {
    private Pacjent pacjent = new Pacjent();

    public Pacjent getPacjent() {
        return pacjent;
    }

    public void setPacjent(Pacjent pacjent) {
        this.pacjent = pacjent;
    }

    public void pacjentListener(ActionEvent ae) {
        String ids = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("pacjentID").toString();
        int id = Integer.parseInt(ids);
        this.pacjent.setId(id);

    }

     public String edytuj() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        em.merge(this.pacjent);
        em.getTransaction().commit();
        em.close();
        this.dodajInformacje("Zmieniono dane pacjenta!");
        this.pacjent = new Pacjent();
        return "/pokazpacjentow.xhtml";
    }

    public String zaladujDoEdycji() {
        EntityManager em = DBManager.getManager().createEntityManager();
        this.pacjent = em.find(Pacjent.class, pacjent.getId());
        em.close();
        return "/edytujpacjenta.xhtml";
    }

    public String usun() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        this.pacjent = em.find(Pacjent.class, pacjent.getId());
        em.remove(this.pacjent);
        this.pacjent = new Pacjent();
        em.getTransaction().commit();
        em.close();
        this.dodajInformacje("Usunieto pacjenta");
        return null;
    }

    public List<Pacjent> getLista() {
        EntityManager em = DBManager.getManager().createEntityManager();
        List<Pacjent> list = em.createNamedQuery("Pacjent.findAll").getResultList();
        em.close();
        return list;
    }

    public String dodaj() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        pacjent.setId(null);
        em.persist(pacjent);
        em.getTransaction().commit();
        em.close();
        this.dodajInformacje("Dodano pacjenta!");
        this.pacjent = new Pacjent();
        return null;
    }

    public void dodajInformacje(String s) {
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, s,""));
    }
}
