package pl.helion.jeeweb.przychodnie.controllers;

import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.persistence.EntityManager;
import pl.helion.jeeweb.przychodnie.config.DBManager;
import pl.helion.jeeweb.przychodnie.entity.Przychodnia;

public class PrzychodniaBean {
    private Przychodnia przychodnia = new Przychodnia();
    
    public Przychodnia getPrzychodnia() {
        return przychodnia;
    }

    public void setPrzychodnia(Przychodnia przychodnia) {
        this.przychodnia = przychodnia;
    }

    public List<Przychodnia> getLista() {
        EntityManager em = DBManager.getManager().createEntityManager();
        List list = em.createNamedQuery("Przychodnia.findAll").getResultList();
        em.close();
        return list;
    }

    public String dodaj() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        przychodnia.setId(null); 
        em.persist(przychodnia);
        em.getTransaction().commit();
        this.dodajInformacje("Dodano przychodnie!");
        em.close();
        this.przychodnia = new Przychodnia();
        return null;
    }

    public String edytuj() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        em.merge(przychodnia);
        em.getTransaction().commit();
        em.close();
        this.dodajInformacje("Zmieniono dane przychodni!");
        this.przychodnia = new Przychodnia();
        return "/pokazprzychodnie.xhtml";
    }

    public void przychodniaListener(ActionEvent ae) {
        String ids = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("przychodniaID").toString();
        int id = Integer.parseInt(ids);
        this.przychodnia.setId(id);
    }

    public String zaladujDoEdycji() {
        EntityManager em = DBManager.getManager().createEntityManager();
        this.przychodnia = em.find(Przychodnia.class, przychodnia.getId());
        em.close();
        return "/edytujprzychodnie.xhtml";
    }

    public String dodajWizyte() {
        EntityManager em = DBManager.getManager().createEntityManager();
        this.przychodnia = em.find(Przychodnia.class, przychodnia.getId());
        em.close();
        return "/dodajwizyte.xhtml";
    }

    public String pokazWizyty() {
        EntityManager em = DBManager.getManager().createEntityManager();
        this.przychodnia = em.find(Przychodnia.class, przychodnia.getId());
        em.close();
        return "/pokazwizyty.xhtml";
    }

    public String usun() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        this.przychodnia = em.find(Przychodnia.class, przychodnia.getId());
        em.remove(this.przychodnia);
        this.przychodnia = new Przychodnia();
        em.getTransaction().commit();
        em.close();
        this.dodajInformacje("Usunieto przychodnie");
        return null;
    }

    public void dodajInformacje(String s) {
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, s,""));
    }
}
