/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.facelets.tag.composite.PropertyHandler;
import com.sun.faces.facelets.tag.composite.TypedPropertyHandler;
import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.ProjectStage;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyHandlerManager {
    private static final Map<String, PropertyHandler> ALL_HANDLERS = new HashMap<String, PropertyHandler>(12, 1.0f);
    private static final String[] DEV_ONLY_ATTRIBUTES;
    private Map<String, PropertyHandler> managedHandlers;
    private PropertyHandler genericHandler = new ObjectValueExpressionPropertyHandler();

    private PropertyHandlerManager(Map<String, PropertyHandler> managedHandlers) {
        this.managedHandlers = managedHandlers;
    }

    static PropertyHandlerManager getInstance(String[] attributes) {
        HashMap<String, PropertyHandler> handlers = new HashMap<String, PropertyHandler>(attributes.length, 1.0f);
        for (String attribute : attributes) {
            handlers.put(attribute, ALL_HANDLERS.get(attribute));
        }
        return new PropertyHandlerManager(handlers);
    }

    PropertyHandler getHandler(FaceletContext ctx, String name) {
        if (!ctx.getFacesContext().isProjectStage(ProjectStage.Development) && Arrays.binarySearch(DEV_ONLY_ATTRIBUTES, name) >= 0) {
            return null;
        }
        PropertyHandler h = this.managedHandlers.get(name);
        return h != null ? h : this.genericHandler;
    }

    static {
        ALL_HANDLERS.put("targets", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("method-signature", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("type", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("default", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("displayName", new DisplayNamePropertyHandler());
        ALL_HANDLERS.put("shortDescription", new ShortDescriptionPropertyHandler());
        ALL_HANDLERS.put("expert", new ExpertPropertyHandler());
        ALL_HANDLERS.put("hidden", new HiddenPropertyHandler());
        ALL_HANDLERS.put("preferred", new PreferredPropertyHandler());
        ALL_HANDLERS.put("required", new BooleanValueExpressionPropertyHandler());
        ALL_HANDLERS.put("name", new NamePropertyHandler());
        ALL_HANDLERS.put("componentType", new ComponentTypePropertyHandler());
        DEV_ONLY_ATTRIBUTES = new String[]{"displayName", "shortDescription", "export", "hidden", "preferred"};
        Arrays.sort(DEV_ONLY_ATTRIBUTES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BooleanFeatureDescriptorPropertyHandler
    implements TypedPropertyHandler {
        private BooleanFeatureDescriptorPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return Boolean.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanValueExpressionPropertyHandler
    extends TypedValueExpressionPropertyHandler {
        private BooleanValueExpressionPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return Boolean.class;
        }
    }

    private static class ComponentTypePropertyHandler
    extends StringValueExpressionPropertyHandler {
        private ComponentTypePropertyHandler() {
        }

        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            super.apply(ctx, "javax.faces.component.COMPOSITE_COMPONENT_TYPE", target, attribute);
        }
    }

    private static final class DisplayNamePropertyHandler
    extends StringFeatureDescriptorPropertyHandler {
        private DisplayNamePropertyHandler() {
        }

        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            ValueExpression ve = attribute.getValueExpression(ctx, this.getEvalType());
            target.setDisplayName((String)ve.getValue((ELContext)ctx));
        }
    }

    private static final class ExpertPropertyHandler
    extends BooleanFeatureDescriptorPropertyHandler {
        private ExpertPropertyHandler() {
        }

        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            ValueExpression ve = attribute.getValueExpression(ctx, this.getEvalType());
            target.setExpert((Boolean)ve.getValue((ELContext)ctx));
        }
    }

    private static final class HiddenPropertyHandler
    extends BooleanFeatureDescriptorPropertyHandler {
        private HiddenPropertyHandler() {
        }

        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            ValueExpression ve = attribute.getValueExpression(ctx, this.getEvalType());
            target.setHidden((Boolean)ve.getValue((ELContext)ctx));
        }
    }

    private static final class NamePropertyHandler
    extends StringFeatureDescriptorPropertyHandler {
        private NamePropertyHandler() {
        }

        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            ValueExpression ve = attribute.getValueExpression(ctx, this.getEvalType());
            String v = (String)ve.getValue((ELContext)ctx);
            if (v != null) {
                target.setShortDescription((String)ve.getValue((ELContext)ctx));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectValueExpressionPropertyHandler
    extends TypedValueExpressionPropertyHandler {
        private ObjectValueExpressionPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return Object.class;
        }
    }

    private static final class PreferredPropertyHandler
    extends BooleanFeatureDescriptorPropertyHandler {
        private PreferredPropertyHandler() {
        }

        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            ValueExpression ve = attribute.getValueExpression(ctx, this.getEvalType());
            target.setPreferred((Boolean)ve.getValue((ELContext)ctx));
        }
    }

    private static final class ShortDescriptionPropertyHandler
    extends StringFeatureDescriptorPropertyHandler {
        private ShortDescriptionPropertyHandler() {
        }

        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            ValueExpression ve = attribute.getValueExpression(ctx, this.getEvalType());
            String v = (String)ve.getValue((ELContext)ctx);
            if (v != null) {
                target.setShortDescription((String)ve.getValue((ELContext)ctx));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class StringFeatureDescriptorPropertyHandler
    implements TypedPropertyHandler {
        private StringFeatureDescriptorPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringValueExpressionPropertyHandler
    extends TypedValueExpressionPropertyHandler {
        private StringValueExpressionPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TypedValueExpressionPropertyHandler
    implements TypedPropertyHandler {
        private TypedValueExpressionPropertyHandler() {
        }

        @Override
        public void apply(FaceletContext ctx, String propName, FeatureDescriptor target, TagAttribute attribute) {
            target.setValue(propName, attribute.getValueExpression(ctx, this.getEvalType()));
        }

        @Override
        public abstract Class<?> getEvalType();
    }
}

