package pl.helion.javaee7.klientogloszen;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by kicia on 04.05.2015.
 */
public class Ogloszenie {
    private int id;
    private String tytul;
    private String autor;
    private Date dataPublikacji;
    private String tresc;

    public Ogloszenie() {

    }

    public Ogloszenie(int id, String tytul, String autor, Date dataPublikacji, String tresc) {
        this.id = id;
        this.tytul = tytul;
        this.autor = autor;
        this.dataPublikacji = dataPublikacji;
        this.tresc = tresc;
    }

    /**
     * @return the tytul
     */
    public String getTytul() {
        return tytul;
    }

    /**
     * @param tytul the tytul to set
     */
    public void setTytul(String tytul) {
        this.tytul = tytul;
    }

    /**
     * @return the autor
     */
    public String getAutor() {
        return autor;
    }

    /**
     * @param autor the autor to set
     */
    public void setAutor(String autor) {
        this.autor = autor;
    }

    /**
     * @return the dataPublikacji
     */
    public Date getDataPublikacji() {
        return dataPublikacji;
    }

    /**
     * @param dataPublikacji the dataPublikacji to set
     */
    public void setDataPublikacji(Date dataPublikacji) {
        this.dataPublikacji = dataPublikacji;
    }

    /**
     * @return the tresc
     */
    public String getTresc() {
        return tresc;
    }

    /**
     * @param tresc the tresc to set
     */
    public void setTresc(String tresc) {
        this.tresc = tresc;
    }

    /**
     * @return the id
     */
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(int id) {
        this.id = id;
    }

    public String toJSON() {
        JSONObject object = new JSONObject();
        try {
            object.put("tytul", this.tytul);
            object.put("tresc", this.tresc);
            object.put("autor", this.autor);
            object.put("id", this.id);
            object.put("dataPublikacji", this.konwersja(this.dataPublikacji));
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return object.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tytul + "\n").append(this.tresc + "\n").append("Autor: " + this.autor + "\n").append("Data publikacji: " + this.dataPublikacji);
        return sb.toString();
    }

    private String konwersja(Date data) {
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return df.format(data);
    }
}
