/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pl.helion.jeeweb.przychodnie.entity;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.IndexColumn;

/**
 *
 * @author k
 */
@Entity
@Table(name = "przychodnia")
@NamedQueries({
    @NamedQuery(name = "Przychodnia.findAll", query = "SELECT p FROM Przychodnia p"),
    @NamedQuery(name = "Przychodnia.findById", query = "SELECT p FROM Przychodnia p WHERE p.id = :id"),
    @NamedQuery(name = "Przychodnia.findByNazwa", query = "SELECT p FROM Przychodnia p WHERE p.nazwa = :nazwa"),
    @NamedQuery(name = "Przychodnia.findByAdres", query = "SELECT p FROM Przychodnia p WHERE p.adres = :adres"),
    @NamedQuery(name = "Przychodnia.findByKontakt", query = "SELECT p FROM Przychodnia p WHERE p.kontakt = :kontakt")})
public class Przychodnia implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "id", nullable = false)
    private Integer id;
    @Basic(optional = false)
    @Column(name = "nazwa", nullable = false, length = 255)
    private String nazwa;
    @Basic(optional = false)
    @Lob
    @Column(name = "opis", nullable = false, length = 65535)
    private String opis;
    @Column(name = "adres", length = 150)
    private String adres;
    @Column(name = "kontakt", length = 30)
    private String kontakt;
    @OneToMany(mappedBy = "przychodnia", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    private Set<Lekarz> lekarzList;
    @OneToMany(mappedBy = "przychodnia", fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    private Set<Pacjent> pacjentList;

    public Przychodnia() {
    }

    public Przychodnia(Integer id) {
        this.id = id;
    }

    public Przychodnia(Integer id, String nazwa, String opis) {
        this.id = id;
        this.nazwa = nazwa;
        this.opis = opis;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNazwa() {
        return nazwa;
    }

    public void setNazwa(String nazwa) {
        this.nazwa = nazwa;
    }

    public String getOpis() {
        return opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public String getAdres() {
        return adres;
    }

    public void setAdres(String adres) {
        this.adres = adres;
    }

    public String getKontakt() {
        return kontakt;
    }

    public void setKontakt(String kontakt) {
        this.kontakt = kontakt;
    }

    public Set<Lekarz> getLekarzList() {
        return lekarzList;
    }

    public void setLekarzList(Set<Lekarz> lekarzList) {
        this.lekarzList = lekarzList;
    }

    public Set<Pacjent> getPacjentList() {
        return pacjentList;
    }

    public void setPacjentList(Set<Pacjent> pacjentList) {
        this.pacjentList = pacjentList;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Przychodnia)) {
            return false;
        }
        Przychodnia other = (Przychodnia) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "pl.helion.jeeweb.przychodnie.entity.Przychodnia[id=" + id + "]";
    }

}
