/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.beans.swing;

import com.mchange.v2.beans.swing.HostBindingInterface;
import com.mchange.v2.beans.swing.PropertyComponentBindingUtility;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;

class PropertyBoundButtonGroup
extends ButtonGroup {
    PropertyComponentBindingUtility pcbu;
    HostBindingInterface myHbi;
    WeChangedListener wcl = new WeChangedListener();
    Map buttonsModelsToValues = new HashMap();
    Map valuesToButtonModels = new HashMap();
    JButton fakeButton = new JButton();

    public PropertyBoundButtonGroup(Object bean, String propName) throws IntrospectionException {
        this.myHbi = new MyHbi();
        this.pcbu = new PropertyComponentBindingUtility(this.myHbi, bean, propName, false);
        this.add(this.fakeButton, null);
        this.pcbu.resync();
    }

    public void add(AbstractButton button, Object associatedValue) {
        super.add(button);
        this.buttonsModelsToValues.put(button.getModel(), associatedValue);
        this.valuesToButtonModels.put(associatedValue, button.getModel());
        button.addActionListener(this.wcl);
        this.pcbu.resync();
    }

    public void add(AbstractButton button) {
        System.err.println(this + "Warning: The button '" + button + "' has been implicitly associated with a null value!");
        System.err.println("To avoid this warning, please use public void add(AbstractButton button, Object associatedValue)");
        System.err.println("instead of the single-argument add method.");
        super.add(button);
        button.addActionListener(this.wcl);
        this.pcbu.resync();
    }

    public void remove(AbstractButton button) {
        button.removeActionListener(this.wcl);
        super.remove(button);
    }

    class MyHbi
    implements HostBindingInterface {
        MyHbi() {
        }

        public void syncToValue(PropertyEditor editor, Object newVal) {
            ButtonModel selectMe = (ButtonModel)PropertyBoundButtonGroup.this.valuesToButtonModels.get(newVal);
            if (selectMe != null) {
                PropertyBoundButtonGroup.this.setSelected(selectMe, true);
            } else {
                PropertyBoundButtonGroup.this.setSelected(PropertyBoundButtonGroup.this.fakeButton.getModel(), true);
            }
        }

        public void addUserModificationListeners() {
        }

        public Object fetchUserModification(PropertyEditor editor, Object oldValue) {
            ButtonModel model = PropertyBoundButtonGroup.this.getSelection();
            return PropertyBoundButtonGroup.this.buttonsModelsToValues.get(model);
        }

        public void alertErroneousInput() {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class WeChangedListener
    implements ActionListener {
        WeChangedListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            PropertyBoundButtonGroup.this.pcbu.userModification();
        }
    }
}

