/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.server.internal.monitoring.TimeWindowStatisticsImpl;
import org.glassfish.jersey.server.monitoring.ExecutionStatistics;
import org.glassfish.jersey.server.monitoring.TimeWindowStatistics;

class ExecutionStatisticsImpl
implements ExecutionStatistics {
    private final Date lastStartTime;
    private final Map<Long, TimeWindowStatistics> timeWindowStatistics;

    @Override
    public Date getLastStartTime() {
        return this.lastStartTime;
    }

    @Override
    public Map<Long, TimeWindowStatistics> getTimeWindowStatistics() {
        return this.timeWindowStatistics;
    }

    @Override
    public ExecutionStatistics snapshot() {
        return this;
    }

    private ExecutionStatisticsImpl(long lastStartTime, Map<Long, TimeWindowStatistics> timeWindowStatistics) {
        this.lastStartTime = new Date(lastStartTime);
        this.timeWindowStatistics = timeWindowStatistics;
    }

    static class Builder {
        private long lastStartTime;
        private final Map<Long, TimeWindowStatisticsImpl.Builder> intervalStatistics = new HashMap<Long, TimeWindowStatisticsImpl.Builder>(4);

        public Builder() {
            this.addInterval(0L, TimeUnit.MILLISECONDS);
            this.addInterval(1L, TimeUnit.SECONDS);
            this.addInterval(15L, TimeUnit.SECONDS);
            this.addInterval(1L, TimeUnit.MINUTES);
            this.addInterval(15L, TimeUnit.MINUTES);
            this.addInterval(1L, TimeUnit.HOURS);
        }

        private void addInterval(long interval, TimeUnit timeUnit) {
            long intervalInMillis = timeUnit.toMillis(interval);
            this.intervalStatistics.put(intervalInMillis, new TimeWindowStatisticsImpl.Builder(intervalInMillis, TimeUnit.MILLISECONDS));
        }

        void addExecution(long startTime, long duration) {
            for (TimeWindowStatisticsImpl.Builder statBuilder : this.intervalStatistics.values()) {
                statBuilder.addRequest(startTime, duration);
            }
            this.lastStartTime = startTime;
        }

        public ExecutionStatisticsImpl build() {
            HashMap newIntervalStatistics = Maps.newHashMap();
            for (Map.Entry<Long, TimeWindowStatisticsImpl.Builder> builderEntry : this.intervalStatistics.entrySet()) {
                newIntervalStatistics.put(builderEntry.getKey(), builderEntry.getValue().build());
            }
            return new ExecutionStatisticsImpl(this.lastStartTime, Collections.unmodifiableMap(newIntervalStatistics));
        }
    }
}

