/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.context.beanstore.AbstractNamingScheme;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class BeanIdentifierIndexNamingScheme
extends AbstractNamingScheme {
    private static final String FALLBACK_FLAG = "F_";
    private final BeanIdentifierIndex index;

    public BeanIdentifierIndexNamingScheme(String delimiter, BeanIdentifierIndex index) {
        super(delimiter);
        this.index = index;
    }

    @Override
    public BeanIdentifier deprefix(String id) {
        String deprefixed = id.substring(this.getPrefix().length() + this.getDelimiter().length());
        if (deprefixed.startsWith(FALLBACK_FLAG)) {
            return new StringBeanIdentifier(deprefixed.substring(FALLBACK_FLAG.length()));
        }
        try {
            return this.index.getIdentifier(Integer.valueOf(deprefixed));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Unable to deprefix id:" + id, e);
        }
    }

    @Override
    public String prefix(BeanIdentifier id) {
        Integer idx = this.index.getIndex(id);
        if (idx == null) {
            return this.getPrefix() + this.getDelimiter() + FALLBACK_FLAG + id.asString();
        }
        return this.getPrefix() + this.getDelimiter() + idx;
    }
}

