/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore.http;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.AttributeBeanStore;
import org.jboss.weld.context.beanstore.LockStore;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.collections.EnumerationList;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractSessionBeanStore
extends AttributeBeanStore {
    private static final String SESSION_KEY = "org.jboss.weld.context.beanstore.http.LockStore";
    private volatile transient LockStore lockStore;
    private static final ThreadLocal<LockStore> CURRENT_LOCK_STORE = new ThreadLocal();

    protected abstract HttpSession getSession(boolean var1);

    public AbstractSessionBeanStore(NamingScheme namingScheme) {
        super(namingScheme);
    }

    @Override
    protected Collection<String> getAttributeNames() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return Collections.emptyList();
        }
        return new EnumerationList<String>((Enumeration)Reflections.cast(session.getAttributeNames()));
    }

    @Override
    protected void removeAttribute(String key) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(key);
            ContextLogger.LOG.removedKeyFromSession(key, this.getSession(false).getId());
        } else {
            ContextLogger.LOG.unableToRemoveKeyFromSession(key);
        }
    }

    @Override
    protected void setAttribute(String key, Object instance) {
        HttpSession session = this.getSession(true);
        if (session != null) {
            session.setAttribute(key, instance);
            ContextLogger.LOG.addedKeyToSession(key, this.getSession(false).getId());
        } else {
            ContextLogger.LOG.unableToAddKeyToSession(key);
        }
    }

    @Override
    public <T> ContextualInstance<T> get(BeanIdentifier id) {
        ContextualInstance instance = super.get(id);
        if (instance == null && this.isAttached()) {
            String prefixedId = this.getNamingScheme().prefix(id);
            instance = (ContextualInstance)Reflections.cast(this.getAttribute(prefixedId));
        }
        return instance;
    }

    @Override
    protected Object getAttribute(String prefixedId) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return session.getAttribute(prefixedId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected LockStore getLockStore() {
        LockStore lockStore = this.lockStore;
        if (lockStore != null) return lockStore;
        lockStore = CURRENT_LOCK_STORE.get();
        if (lockStore != null) {
            return lockStore;
        }
        HttpSession session = this.getSession(false);
        if (session == null) {
            lockStore = new LockStore();
            CURRENT_LOCK_STORE.set(lockStore);
            try {
                session = this.getSession(true);
            }
            finally {
                CURRENT_LOCK_STORE.remove();
            }
        }
        if ((lockStore = (LockStore)session.getAttribute(SESSION_KEY)) == null) {
            Class<AbstractSessionBeanStore> clazz = AbstractSessionBeanStore.class;
            // MONITORENTER : org.jboss.weld.context.beanstore.http.AbstractSessionBeanStore.class
            lockStore = (LockStore)session.getAttribute(SESSION_KEY);
            if (lockStore == null) {
                lockStore = new LockStore();
                session.setAttribute(SESSION_KEY, (Object)lockStore);
            }
            // MONITOREXIT : clazz
        }
        this.lockStore = lockStore;
        return lockStore;
    }
}

