/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.relational.UniqueKey;

public class DefaultUniqueDelegate
implements UniqueDelegate {
    protected final Dialect dialect;

    public DefaultUniqueDelegate(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String applyUniqueToColumn(Column column) {
        return "";
    }

    @Override
    public String applyUniqueToColumn(org.hibernate.metamodel.relational.Column column) {
        return "";
    }

    @Override
    public String applyUniquesToTable(Table table) {
        return "";
    }

    @Override
    public String applyUniquesToTable(org.hibernate.metamodel.relational.Table table) {
        return "";
    }

    @Override
    public String applyUniquesOnAlter(org.hibernate.mapping.UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect, defaultCatalog, defaultSchema) + " add constraint " + uniqueKey.getName() + this.uniqueConstraintSql(uniqueKey);
    }

    @Override
    public String applyUniquesOnAlter(UniqueKey uniqueKey) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect) + " add constraint " + uniqueKey.getName() + this.uniqueConstraintSql(uniqueKey);
    }

    @Override
    public String dropUniquesOnAlter(org.hibernate.mapping.UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect, defaultCatalog, defaultSchema) + " drop constraint " + this.dialect.quote(uniqueKey.getName());
    }

    @Override
    public String dropUniquesOnAlter(UniqueKey uniqueKey) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect) + " drop constraint " + this.dialect.quote(uniqueKey.getName());
    }

    @Override
    public String uniqueConstraintSql(org.hibernate.mapping.UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(" unique (");
        Iterator columnIterator = uniqueKey.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)columnIterator.next();
            sb.append(column.getQuotedName(this.dialect));
            if (!columnIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }

    @Override
    public String uniqueConstraintSql(UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(" unique (");
        Iterator<org.hibernate.metamodel.relational.Column> columnIterator = uniqueKey.getColumns().iterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)((Object)columnIterator.next());
            sb.append(column.getQuotedName(this.dialect));
            if (!columnIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }
}

