/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.servlet.EnhancedListener;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;

public class Listener
extends ForwardingServletListener {
    public static final String LISTENER_USED_ATTRIBUTE_NAME = EnhancedListener.class.getPackage().getName() + ".listenerUsed";
    private static final Logger log = Logger.getLogger(Listener.class);
    private boolean isEnhancedListenerUsed;
    private WeldServletLifecycle lifecycle;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        this.lifecycle = (WeldServletLifecycle)context.getAttribute(WeldServletLifecycle.INSTANCE_ATTRIBUTE_NAME);
        if (this.lifecycle != null) {
            this.isEnhancedListenerUsed = true;
        }
        context.setAttribute(LISTENER_USED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
        if (this.isEnhancedListenerUsed) {
            log.info("org.jboss.weld.environment.servlet.EnhancedListener used for ServletContext notifications");
            return;
        }
        log.info("Initialize Weld using ServletContextListener");
        this.lifecycle = new WeldServletLifecycle();
        this.lifecycle.initialize(context);
        super.contextInitialized(sce);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (this.isEnhancedListenerUsed) {
            return;
        }
        this.lifecycle.destroy(sce.getServletContext());
        super.contextDestroyed(sce);
    }

    @Override
    protected ServletListener delegate() {
        return this.lifecycle.getWeldListener();
    }
}

