/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.drda.CodePointNameTable;

public class DssTrace {
    private static final String LIST_SEPARATOR = " # ";
    private static final String NULL_VALUE = "null";
    private static final char[] asciiChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static CodePointNameTable codePointNameTable = null;
    private static final String colPosHeader = "       0 1 2 3 4 5 6 7   8 9 A B C D E F   0123456789ABCDEF  0123456789ABCDEF";
    private static final char[] ebcdicChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '|', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '`', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '.', '.', '.', '.', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '.', '.', '.', '.', '.', '.', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '\\', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private PrintWriter comBufferWriter = null;
    private static final String receiveHeader = "       RECEIVE BUFFER:                     (ASCII)           (EBCDIC)";
    private static final String sendHeader = "       SEND BUFFER:                        (ASCII)           (EBCDIC)";
    private static final char spaceChar = ' ';
    private boolean comBufferTraceOn = false;
    private final Object comBufferSync = new Object();
    private static final char zeroChar = '0';
    protected static final int TYPE_TRACE_RECEIVE = 2;
    protected static final int TYPE_TRACE_SEND = 1;

    protected boolean isComBufferTraceOn() {
        return this.comBufferTraceOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComBufferTrace(final String string) throws Exception {
        Object object = this.comBufferSync;
        synchronized (object) {
            if (!this.comBufferTraceOn) {
                for (int i = 0; i < 2; ++i) {
                    try {
                        this.comBufferWriter = AccessController.doPrivileged(new PrivilegedExceptionAction<PrintWriter>(){

                            @Override
                            public PrintWriter run() throws SecurityException, IOException {
                                File file = new File(string);
                                boolean bl = file.exists();
                                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string), 4096));
                                if (!bl) {
                                    FileUtil.limitAccessToOwner(file);
                                }
                                return printWriter;
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (i == 0 && exception instanceof FileNotFoundException) {
                            final File file = new File(string).getParentFile();
                            if (file == null) continue;
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    boolean bl = file.mkdir();
                                    if (!bl) {
                                        bl = file.mkdirs();
                                    }
                                    if (bl) {
                                        FileUtil.limitAccessToOwner(file);
                                    }
                                    return null;
                                }
                            });
                            continue;
                        }
                        throw exception;
                    }
                }
                this.comBufferTraceOn = true;
                if (codePointNameTable == null) {
                    codePointNameTable = new CodePointNameTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopComBufferTrace() {
        Object object = this.comBufferSync;
        synchronized (object) {
            if (this.comBufferTraceOn) {
                this.comBufferTraceOn = false;
                if (this.comBufferWriter != null) {
                    this.comBufferWriter.flush();
                    this.comBufferWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeComBufferData(byte[] byArray, int n, int n2, int n3, String string, String string2, int n4) {
        Object object = this.comBufferSync;
        synchronized (object) {
            if (this.comBufferTraceOn) {
                Calendar calendar = Calendar.getInstance();
                this.comBufferWriter.println("       (" + calendar.get(1) + "." + (calendar.get(2) + 1) + "." + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + ") " + string + " " + string2 + " " + Thread.currentThread().getName() + " " + n4);
                this.comBufferWriter.println();
                if (n2 != 0) {
                    int n5;
                    String string3 = null;
                    if (n2 >= 10) {
                        int n6 = DssTrace.getCodePoint(byArray, n + 8);
                        string3 = codePointNameTable.lookup(n6);
                    }
                    if (string3 == null) {
                        this.comBufferWriter.println(DssTrace.getHeader(n3));
                    } else {
                        this.printHeaderWithCodePointName(string3, n3);
                    }
                    this.comBufferWriter.println(colPosHeader);
                    char[] cArray = new char[77];
                    int n7 = 7;
                    int n8 = 43;
                    int n9 = 61;
                    cArray[0] = 48;
                    cArray[1] = 48;
                    cArray[2] = 48;
                    cArray[3] = 48;
                    int n10 = 16;
                    for (n5 = 4; n5 < 77; ++n5) {
                        cArray[n5] = 32;
                    }
                    n5 = 0;
                    do {
                        int n11 = byArray[n] < 0 ? byArray[n] + 256 : byArray[n];
                        ++n;
                        ++n5;
                        int n12 = n7;
                        n7 = (short)(n7 + 1);
                        cArray[n12] = hexDigit[n11 >>> 4 & 0xF];
                        int n13 = n7;
                        n7 = (short)(n7 + 1);
                        cArray[n13] = hexDigit[n11 & 0xF];
                        int n14 = n8;
                        n8 = (short)(n8 + 1);
                        cArray[n14] = asciiChar[n11];
                        int n15 = n9;
                        n9 = (short)(n9 + 1);
                        cArray[n15] = ebcdicChar[n11];
                        if (n5 % 8 != 0) continue;
                        if (n5 % 16 == 0) {
                            this.comBufferWriter.println(cArray);
                            if (n5 == n2) continue;
                            if (n2 - n5 < 16) {
                                for (int i = 0; i < cArray.length; ++i) {
                                    cArray[i] = 32;
                                }
                            }
                            n7 = 0;
                            n8 = 43;
                            n9 = 61;
                            if (n10 == 65520) {
                                n10 = 0;
                            }
                            int n16 = n7;
                            n7 = (short)(n7 + 1);
                            cArray[n16] = hexDigit[n10 >>> 12 & 0xF];
                            int n17 = n7;
                            n7 = (short)(n7 + 1);
                            cArray[n17] = hexDigit[n10 >>> 8 & 0xF];
                            int n18 = n7;
                            n7 = (short)(n7 + 1);
                            cArray[n18] = hexDigit[n10 >>> 4 & 0xF];
                            int n19 = n7;
                            n7 = (short)(n7 + 1);
                            cArray[n19] = hexDigit[n10 & 0xF];
                            n7 = (short)(n7 + 3);
                            n10 += 16;
                            continue;
                        }
                        n7 = (short)(n7 + 2);
                    } while (n5 < n2);
                    if (n2 % 16 != 0) {
                        this.comBufferWriter.println(cArray);
                    }
                    this.comBufferWriter.println();
                    this.comBufferWriter.println();
                }
                this.comBufferWriter.flush();
            }
        }
    }

    private static int getCodePoint(byte[] byArray, int n) {
        return ((byArray[n++] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0);
    }

    private static String getHeader(int n) {
        switch (n) {
            case 1: {
                return sendHeader;
            }
            case 2: {
                return receiveHeader;
            }
        }
        return null;
    }

    private static int getStartPosition(int n) {
        switch (n) {
            case 1: {
                return 20;
            }
            case 2: {
                return 23;
            }
        }
        return 0;
    }

    private void printHeaderWithCodePointName(String string, int n) {
        char[] cArray = DssTrace.getHeader(n).toCharArray();
        int n2 = string.length() < 17 ? string.length() : 16;
        int n3 = DssTrace.getStartPosition(n);
        for (int i = 0; i < n2; ++i) {
            cArray[n3++] = string.charAt(i);
        }
        this.comBufferWriter.println(cArray);
    }
}

