/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;

public class LibraryInfo {
    private String name;
    private VersionInfo version;
    private String localePrefix;
    private String contract;
    private ResourceHelper helper;
    private String path;
    private String nonLocalizedPath;

    LibraryInfo(String name, VersionInfo version, String localePrefix, String contract, ResourceHelper helper) {
        this.name = name;
        this.version = version;
        this.localePrefix = localePrefix;
        this.contract = contract;
        this.helper = helper;
        this.initPath();
    }

    LibraryInfo(LibraryInfo other, boolean copyLocalePrefix) {
        this.name = other.name;
        this.version = other.version;
        if (copyLocalePrefix) {
            this.contract = other.contract;
            this.localePrefix = other.localePrefix;
        }
        this.helper = other.helper;
        this.initPath();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LibraryInfo other = (LibraryInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!(this.version == other.version || this.version != null && this.version.equals(other.version))) {
            return false;
        }
        if (this.localePrefix == null ? other.localePrefix != null : !this.localePrefix.equals(other.localePrefix)) {
            return false;
        }
        if (this.contract == null ? other.contract != null : !this.contract.equals(other.contract)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 37 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 37 * hash + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        hash = 37 * hash + (this.contract != null ? this.contract.hashCode() : 0);
        hash = 37 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(String localePrefix) {
        String result = null;
        result = null == localePrefix ? this.nonLocalizedPath : this.path;
        return result;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String toString() {
        return "LibraryInfo{name='" + this.name + '\'' + ", version=" + (this.version != null ? this.version : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", contract='" + (this.contract != null ? this.contract : "NONE") + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private void initPath() {
        StringBuilder builder = new StringBuilder(64);
        StringBuilder noLocaleBuilder = new StringBuilder(64);
        this.appendBasePath(builder);
        this.appendBasePath(noLocaleBuilder);
        if (this.localePrefix != null) {
            builder.append('/').append(this.localePrefix);
        }
        builder.append('/').append(this.name);
        noLocaleBuilder.append('/').append(this.name);
        if (this.version != null) {
            builder.append('/').append(this.version.getVersion());
            noLocaleBuilder.append('/').append(this.version.getVersion());
        }
        this.path = builder.toString();
        this.nonLocalizedPath = noLocaleBuilder.toString();
    }

    private void appendBasePath(StringBuilder builder) {
        if (this.contract == null) {
            builder.append(this.helper.getBaseResourcePath());
        } else {
            builder.append(this.helper.getBaseContractsPath()).append('/').append(this.contract);
        }
    }
}

