/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationStateInfo;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateContext {
    private static final String KEY = StateContext.class.getName() + "_KEY";
    private boolean partial;
    private boolean partialLocked;
    private boolean trackMods = true;
    private AddRemoveListener modListener;
    private ApplicationStateInfo stateInfo;
    private WeakReference<UIViewRoot> viewRootRef = new WeakReference<Object>(null);
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();

    private StateContext(ApplicationStateInfo stateInfo) {
        this.stateInfo = stateInfo;
    }

    public static void release(FacesContext facesContext) {
        StateContext stateContext = (StateContext)facesContext.getAttributes().get(KEY);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null && stateContext.modListener != null) {
            viewRoot.unsubscribeFromViewEvent(PostAddToViewEvent.class, stateContext.modListener);
            viewRoot.unsubscribeFromViewEvent(PreRemoveFromViewEvent.class, stateContext.modListener);
        }
        facesContext.getAttributes().remove(KEY);
    }

    public static StateContext getStateContext(FacesContext ctx) {
        StateContext stateCtx = (StateContext)ctx.getAttributes().get(KEY);
        if (stateCtx == null) {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            ApplicationStateInfo info = associate.getApplicationStateInfo();
            stateCtx = new StateContext(info);
            ctx.getAttributes().put(KEY, stateCtx);
        }
        return stateCtx;
    }

    public boolean isPartialStateSaving(FacesContext ctx, String viewId) {
        UIViewRoot refRoot;
        UIViewRoot root = ctx.getViewRoot();
        if (root != (refRoot = (UIViewRoot)this.viewRootRef.get())) {
            this.viewRootRef = new WeakReference<UIViewRoot>(root);
            if (refRoot != null) {
                this.modListener = null;
                this.partialLocked = false;
            }
        }
        if (!this.partialLocked) {
            if (viewId == null) {
                viewId = root != null ? root.getViewId() : (String)ctx.getAttributes().get("com.sun.faces.viewId");
            }
            this.partial = this.stateInfo.usePartialStateSaving(viewId);
            this.partialLocked = true;
        }
        return this.partial;
    }

    public boolean trackViewModifications() {
        return this.trackMods;
    }

    public void startTrackViewModifications(FacesContext ctx, UIViewRoot root) {
        if (this.modListener == null) {
            if (root != null) {
                this.modListener = new AddRemoveListener(ctx);
                root.subscribeToViewEvent(PostAddToViewEvent.class, this.modListener);
                root.subscribeToViewEvent(PreRemoveFromViewEvent.class, this.modListener);
            } else {
                LOGGER.warning("Unable to attach AddRemoveListener to UIViewRoot because it is null");
            }
        }
        this.setTrackViewModifications(true);
    }

    public void setTrackViewModifications(boolean trackMods) {
        this.trackMods = trackMods;
    }

    public boolean componentAddedDynamically(UIComponent c) {
        return c.getAttributes().containsKey("com.sun.faces.DynamicComponent");
    }

    public int getIndexOfDynamicallyAddedChildInParent(UIComponent c) {
        int result = -1;
        Map<String, Object> attrs = c.getAttributes();
        if (attrs.containsKey("com.sun.faces.DynamicComponent")) {
            result = (Integer)attrs.get("com.sun.faces.DynamicComponent");
        }
        return result;
    }

    public boolean hasOneOrMoreDynamicChild(UIComponent parent) {
        return parent.getAttributes().containsKey("com.sun.faces.DynamicChildCount");
    }

    private int incrementDynamicChildCount(UIComponent parent) {
        int result;
        Map<String, Object> attrs = parent.getAttributes();
        Integer cur = (Integer)attrs.get("com.sun.faces.DynamicChildCount");
        if (null != cur) {
            Integer n = cur;
            Integer n2 = cur = Integer.valueOf(cur + 1);
            result = n;
        } else {
            result = 1;
        }
        attrs.put("com.sun.faces.DynamicChildCount", result);
        return result;
    }

    private int decrementDynamicChildCount(UIComponent parent) {
        int result = 0;
        Map<String, Object> attrs = parent.getAttributes();
        Integer cur = (Integer)attrs.get("com.sun.faces.DynamicChildCount");
        if (null != cur) {
            int n;
            if (0 < cur) {
                Integer n2 = cur;
                Integer n3 = cur = Integer.valueOf(cur - 1);
                n = n2;
            } else {
                n = result = 0;
            }
        }
        if (0 == result && null != cur) {
            attrs.remove("com.sun.faces.DynamicChildCount");
        }
        return result;
    }

    public List<ComponentStruct> getDynamicActions() {
        return this.modListener != null ? this.modListener.getDynamicActions() : null;
    }

    public HashMap<String, UIComponent> getDynamicComponents() {
        return this.modListener != null ? this.modListener.getDynamicComponents() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddRemoveListener
    implements SystemEventListener {
        private StateContext stateCtx;
        private List<ComponentStruct> dynamicActions;
        private transient HashMap<String, UIComponent> dynamicComponents;

        public AddRemoveListener(FacesContext context) {
            this.stateCtx = StateContext.getStateContext(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ComponentStruct> getDynamicActions() {
            AddRemoveListener addRemoveListener = this;
            synchronized (addRemoveListener) {
                if (this.dynamicActions == null) {
                    this.dynamicActions = new ArrayList<ComponentStruct>();
                }
            }
            return this.dynamicActions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashMap<String, UIComponent> getDynamicComponents() {
            AddRemoveListener addRemoveListener = this;
            synchronized (addRemoveListener) {
                if (this.dynamicComponents == null) {
                    this.dynamicComponents = new HashMap();
                }
            }
            return this.dynamicComponents;
        }

        @Override
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext ctx = FacesContext.getCurrentInstance();
            if (event instanceof PreRemoveFromViewEvent) {
                if (this.stateCtx.trackViewModifications()) {
                    this.handleRemove(ctx, ((PreRemoveFromViewEvent)event).getComponent());
                }
            } else if (this.stateCtx.trackViewModifications()) {
                this.handleAdd(ctx, ((PostAddToViewEvent)event).getComponent());
            }
        }

        @Override
        public boolean isListenerForSource(Object source) {
            return source instanceof UIComponent && !(source instanceof UIViewRoot);
        }

        private void handleRemove(FacesContext context, UIComponent component) {
            if (component.isInView()) {
                StateContext.this.decrementDynamicChildCount(component.getParent());
                ComponentStruct struct = new ComponentStruct();
                struct.action = "REMOVE";
                struct.clientId = component.getClientId(context);
                struct.id = component.getId();
                this.handleAddRemoveWithAutoPrune(component, struct);
            }
        }

        private void handleAdd(FacesContext context, UIComponent component) {
            if (component.getParent() != null && component.getParent().isInView()) {
                String facetName;
                String id = component.getId();
                if (id != null) {
                    component.setId(id);
                }
                if ((facetName = this.findFacetNameForComponent(component)) != null) {
                    StateContext.this.incrementDynamicChildCount(component.getParent());
                    component.clearInitialState();
                    component.getAttributes().put("com.sun.faces.DynamicComponent", component.getParent().getChildren().indexOf(component));
                    ComponentStruct struct = new ComponentStruct();
                    struct.action = "ADD";
                    struct.facetName = facetName;
                    struct.parentClientId = component.getParent().getClientId(context);
                    struct.clientId = component.getClientId(context);
                    struct.id = component.getId();
                    this.handleAddRemoveWithAutoPrune(component, struct);
                } else {
                    StateContext.this.incrementDynamicChildCount(component.getParent());
                    component.clearInitialState();
                    component.getAttributes().put("com.sun.faces.DynamicComponent", component.getParent().getChildren().indexOf(component));
                    ComponentStruct struct = new ComponentStruct();
                    struct.action = "ADD";
                    struct.parentClientId = component.getParent().getClientId(context);
                    struct.clientId = component.getClientId(context);
                    struct.id = component.getId();
                    this.handleAddRemoveWithAutoPrune(component, struct);
                }
            }
        }

        private String findFacetNameForComponent(UIComponent component) {
            Set<Map.Entry<String, UIComponent>> entrySet = component.getParent().getFacets().entrySet();
            for (Map.Entry<String, UIComponent> candidate : entrySet) {
                if (component != candidate.getValue()) continue;
                return candidate.getKey();
            }
            return null;
        }

        private void handleAddRemoveWithAutoPrune(UIComponent component, ComponentStruct struct) {
            List<ComponentStruct> actionList = this.getDynamicActions();
            HashMap<String, UIComponent> componentMap = this.getDynamicComponents();
            int firstIndex = actionList.indexOf(struct);
            if (firstIndex == -1) {
                actionList.add(struct);
                componentMap.put(struct.clientId, component);
            } else {
                int lastIndex = actionList.lastIndexOf(struct);
                if (lastIndex == firstIndex) {
                    ComponentStruct previousStruct = actionList.get(firstIndex);
                    if ("ADD".equals(previousStruct.action)) {
                        if ("ADD".equals(struct.action)) {
                            throw new FacesException("Cannot add the same component twice: " + struct.clientId);
                        }
                        if ("REMOVE".equals(struct.action)) {
                            actionList.remove(firstIndex);
                            componentMap.remove(struct.clientId);
                        }
                    }
                    if ("REMOVE".equals(previousStruct.action)) {
                        if ("ADD".equals(struct.action)) {
                            actionList.add(struct);
                            componentMap.put(struct.clientId, component);
                        }
                        if ("REMOVE".equals(struct.action)) {
                            throw new FacesException("Cannot remove the same component twice: " + struct.clientId);
                        }
                    }
                } else {
                    if ("ADD".equals(struct.action)) {
                        throw new FacesException("Cannot add the same component twice: " + struct.clientId);
                    }
                    if ("REMOVE".equals(struct.action)) {
                        actionList.remove(lastIndex);
                    }
                }
            }
        }
    }
}

