/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;

public class UnmarshalCallback {
    private Class domainClass;
    private String domainClassName;
    private Method afterUnmarshalCallback;
    private Method beforeUnmarshalCallback;
    private boolean hasAfterUnmarshalCallback = false;
    private boolean hasBeforeUnmarshalCallback = false;

    public Method getAfterUnmarshalCallback() {
        return this.afterUnmarshalCallback;
    }

    public Method getBeforeUnmarshalCallback() {
        return this.beforeUnmarshalCallback;
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    public void initialize(ClassLoader loader) {
        block22: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.domainClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.domainClassName, true, loader));
                        break block22;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                this.domainClass = PrivilegedAccessHelper.getClassForName(this.domainClassName, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
        }
        Class[] params = new Class[]{Unmarshaller.class, Object.class};
        if (this.hasBeforeUnmarshalCallback) {
            try {
                Method beforeUnmarshal = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        beforeUnmarshal = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "beforeUnmarshal", params, false));
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                } else {
                    beforeUnmarshal = PrivilegedAccessHelper.getMethod(this.domainClass, "beforeUnmarshal", params, false);
                }
                this.setBeforeUnmarshalCallback(beforeUnmarshal);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (this.hasAfterUnmarshalCallback) {
            try {
                Method afterUnmarshal = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        afterUnmarshal = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "afterUnmarshal", params, false));
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                } else {
                    afterUnmarshal = PrivilegedAccessHelper.getMethod(this.domainClass, "afterUnmarshal", params, false);
                }
                this.setAfterUnmarshalCallback(afterUnmarshal);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public void setAfterUnmarshalCallback(Method method) {
        this.afterUnmarshalCallback = method;
    }

    public void setHasAfterUnmarshalCallback() {
        this.hasAfterUnmarshalCallback = true;
    }

    public void setBeforeUnmarshalCallback(Method method) {
        this.beforeUnmarshalCallback = method;
    }

    public void setHasBeforeUnmarshalCallback() {
        this.hasBeforeUnmarshalCallback = true;
    }

    public void setDomainClass(Class clazz) {
        this.domainClass = clazz;
        this.setDomainClassName(clazz.getName());
    }

    public void setDomainClassName(String className) {
        this.domainClassName = className;
    }
}

