/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.EnterpriseBeanInstance;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;

public class EnterpriseProxyFactory<T>
extends ProxyFactory<T> {
    private static final String SUFFIX = "$EnterpriseProxy$";

    public EnterpriseProxyFactory(Class<T> proxiedBeanType, SessionBean<T> bean) {
        super(bean.getBeanManager().getContextId(), proxiedBeanType, (Set<? extends Type>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(bean.getTypes())).addAll(bean.getEjbDescriptor().getRemoteBusinessInterfacesAsClasses())).build()), bean);
    }

    @Override
    protected void addSpecialMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        super.addSpecialMethods(proxyClassType, staticConstructor);
        try {
            proxyClassType.addInterface(EnterpriseBeanInstance.class.getName());
            for (Method method : EnterpriseBeanInstance.class.getMethods()) {
                BeanLogger.LOG.addingMethodToEnterpriseProxy(method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                this.createInterceptorBody(proxyClassType.addMethod(method), methodInfo, staticConstructor);
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    protected String getProxyNameSuffix() {
        return SUFFIX;
    }
}

