/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.weld.environment.jetty.JettyWeldInjector;

public class WeldDecorator
implements ServletContextHandler.Decorator {
    private ServletContext servletContext;
    private JettyWeldInjector injector;

    protected WeldDecorator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static void process(ServletContext context) {
        ContextHandler.Context cc;
        ContextHandler handler;
        if (context instanceof ContextHandler.Context && (handler = (cc = (ContextHandler.Context)context).getContextHandler()) instanceof ServletContextHandler) {
            ServletContextHandler sch = (ServletContextHandler)handler;
            sch.addDecorator((ServletContextHandler.Decorator)new WeldDecorator(context));
        }
    }

    protected JettyWeldInjector getInjector() {
        if (this.injector == null) {
            JettyWeldInjector jwi = (JettyWeldInjector)this.servletContext.getAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector");
            if (jwi == null) {
                throw new IllegalArgumentException("No such Jetty injector found in servlet context attributes.");
            }
            this.injector = jwi;
        }
        return this.injector;
    }

    public <T extends Filter> T decorateFilterInstance(T filter) throws ServletException {
        return this.decorate(filter);
    }

    public <T extends Servlet> T decorateServletInstance(T servlet) throws ServletException {
        return this.decorate(servlet);
    }

    public <T extends EventListener> T decorateListenerInstance(T listener) throws ServletException {
        return this.decorate(listener);
    }

    public void decorateFilterHolder(FilterHolder filter) throws ServletException {
    }

    public void decorateServletHolder(ServletHolder servlet) throws ServletException {
    }

    public void destroyServletInstance(Servlet s) {
        this.destroy(s);
    }

    public void destroyFilterInstance(Filter f) {
        this.destroy(f);
    }

    public void destroyListenerInstance(EventListener f) {
        this.destroy(f);
    }

    public <T> T decorate(T o) {
        this.getInjector().inject(o);
        return o;
    }

    public void destroy(Object o) {
        this.getInjector().destroy(o);
    }
}

