/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HierarchicalQueryClause
extends AbstractExpression {
    private AbstractExpression connectByClause;
    private boolean hasSpaceAfterConnectByClause;
    private boolean hasSpaceAfterStartWithClause;
    private AbstractExpression orderSiblingsByClause;
    private AbstractExpression startWithClause;

    public HierarchicalQueryClause(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getStartWithClause().accept(visitor);
        this.getConnectByClause().accept(visitor);
        this.getOrderSiblingsByClause().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        super.addChildrenTo(children);
        children.add(this.getStartWithClause());
        children.add(this.getConnectByClause());
        children.add(this.getOrderSiblingsByClause());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.startWithClause != null) {
            children.add(this.startWithClause);
        }
        if (this.hasSpaceAfterStartWithClause) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.connectByClause != null) {
            children.add(this.connectByClause);
        }
        if (this.hasSpaceAfterConnectByClause) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.orderSiblingsByClause != null) {
            children.add(this.orderSiblingsByClause);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.startWithClause != null && this.startWithClause.isAncestor(expression)) {
            return this.getQueryBNF("START WITH");
        }
        if (this.connectByClause != null && this.connectByClause.isAncestor(expression)) {
            return this.getQueryBNF("connectby_clause");
        }
        if (this.orderSiblingsByClause != null && this.orderSiblingsByClause.isAncestor(expression)) {
            return this.getQueryBNF("order_sibling_by_clause");
        }
        return super.findQueryBNF(expression);
    }

    public Expression getConnectByClause() {
        if (this.connectByClause == null) {
            this.connectByClause = this.buildNullExpression();
        }
        return this.connectByClause;
    }

    public Expression getOrderSiblingsByClause() {
        if (this.orderSiblingsByClause == null) {
            this.orderSiblingsByClause = this.buildNullExpression();
        }
        return this.orderSiblingsByClause;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("hierarchical_query_clause");
    }

    public Expression getStartWithClause() {
        if (this.startWithClause == null) {
            this.startWithClause = this.buildNullExpression();
        }
        return this.startWithClause;
    }

    public boolean hasConnectByClause() {
        return this.connectByClause != null && !this.connectByClause.isNull();
    }

    public boolean hasOrderSiblingsByClause() {
        return this.orderSiblingsByClause != null && !this.orderSiblingsByClause.isNull();
    }

    public boolean hasSpaceAfterConnectByClause() {
        return this.hasSpaceAfterConnectByClause;
    }

    public boolean hasSpaceAfterStartWithClause() {
        return this.hasSpaceAfterStartWithClause;
    }

    public boolean hasStartWithClause() {
        return this.startWithClause != null && !this.startWithClause.isNull();
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        int count = 0;
        if (wordParser.startsWithIdentifier("START WITH")) {
            this.startWithClause = new StartWithClause(this);
            this.startWithClause.parse(wordParser, tolerant);
            count = wordParser.skipLeadingWhitespace();
            boolean bl = this.hasSpaceAfterStartWithClause = count > 0;
        }
        if (wordParser.startsWithIdentifier("CONNECT BY")) {
            this.connectByClause = new ConnectByClause(this);
            this.connectByClause.parse(wordParser, tolerant);
            count = wordParser.skipLeadingWhitespace();
            boolean bl = this.hasSpaceAfterConnectByClause = count > 0;
        }
        if (wordParser.startsWithIdentifier("ORDER SIBLINGS BY")) {
            this.orderSiblingsByClause = new OrderSiblingsByClause(this);
            this.orderSiblingsByClause.parse(wordParser, tolerant);
        }
        if (this.hasSpaceAfterStartWithClause && this.connectByClause == null && this.orderSiblingsByClause == null) {
            this.hasSpaceAfterStartWithClause = false;
            wordParser.moveBackward(count);
        } else if (this.hasSpaceAfterConnectByClause && this.orderSiblingsByClause == null) {
            this.hasSpaceAfterConnectByClause = false;
            wordParser.moveBackward(count);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.startWithClause != null) {
            this.startWithClause.toParsedText(writer, actual);
            if (this.hasSpaceAfterStartWithClause) {
                writer.append(' ');
            }
        }
        if (this.connectByClause != null) {
            this.connectByClause.toParsedText(writer, actual);
            if (this.hasSpaceAfterConnectByClause) {
                writer.append(' ');
            }
        }
        if (this.orderSiblingsByClause != null) {
            this.orderSiblingsByClause.toParsedText(writer, actual);
        }
    }
}

