/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.engine.jdbc.batch.internal.AbstractBatchImpl;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class NonBatchingBatch
extends AbstractBatchImpl {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)NonBatchingBatch.class.getName());
    private JdbcCoordinator jdbcCoordinator;

    protected NonBatchingBatch(BatchKey key, JdbcCoordinator jdbcCoordinator) {
        super(key, jdbcCoordinator);
        this.jdbcCoordinator = jdbcCoordinator;
    }

    @Override
    public void addToBatch() {
        this.notifyObserversImplicitExecution();
        for (Map.Entry<String, PreparedStatement> entry : this.getStatements().entrySet()) {
            try {
                PreparedStatement statement = entry.getValue();
                int rowCount = this.jdbcCoordinator.getResultSetReturn().executeUpdate(statement);
                this.getKey().getExpectation().verifyOutcome(rowCount, statement, 0);
                this.jdbcCoordinator.release(statement);
            }
            catch (SQLException e) {
                LOG.debug("SQLException escaped proxy", e);
                throw this.sqlExceptionHelper().convert(e, "could not execute batch statement", entry.getKey());
            }
        }
        this.getStatements().clear();
    }

    @Override
    protected void doExecuteBatch() {
    }
}

