/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.internal;

import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.JerseyRequestTimeoutHandler;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;

public class ResponseWriter
implements ContainerResponseWriter {
    private static final Logger LOGGER = Logger.getLogger(ResponseWriter.class.getName());
    private final HttpServletResponse response;
    private final boolean useSetStatusOn404;
    private final boolean configSetStatusOverSendError;
    private final SettableFuture<ContainerResponse> responseContext;
    private final AsyncContextDelegate asyncExt;
    private final JerseyRequestTimeoutHandler requestTimeoutHandler;

    public ResponseWriter(boolean useSetStatusOn404, boolean configSetStatusOverSendError, HttpServletResponse response, AsyncContextDelegate asyncExt, ScheduledExecutorService timeoutTaskExecutor) {
        this.useSetStatusOn404 = useSetStatusOn404;
        this.configSetStatusOverSendError = configSetStatusOverSendError;
        this.response = response;
        this.asyncExt = asyncExt;
        this.responseContext = SettableFuture.create();
        this.requestTimeoutHandler = new JerseyRequestTimeoutHandler((ContainerResponseWriter)this, timeoutTaskExecutor);
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        try {
            this.asyncExt.suspend();
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.SERVLET_REQUEST_SUSPEND_FAILED(), ex);
            return false;
        }
        return this.requestTimeoutHandler.suspend(timeOut, timeUnit, timeoutHandler);
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        this.requestTimeoutHandler.setSuspendTimeout(timeOut, timeUnit);
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
        this.responseContext.set((Object)responseContext);
        if (responseContext.hasEntity() && contentLength != -1L && contentLength < Integer.MAX_VALUE) {
            this.response.setContentLength((int)contentLength);
        }
        MultivaluedMap headers = this.getResponseContext().getStringHeaders();
        for (Map.Entry e : headers.entrySet()) {
            Iterator it = ((List)e.getValue()).iterator();
            if (!it.hasNext()) continue;
            String header = (String)e.getKey();
            if (this.response.containsHeader(header)) {
                this.response.setHeader(header, (String)it.next());
            }
            while (it.hasNext()) {
                this.response.addHeader(header, (String)it.next());
            }
        }
        String reasonPhrase = responseContext.getStatusInfo().getReasonPhrase();
        if (reasonPhrase != null) {
            this.response.setStatus(responseContext.getStatus(), reasonPhrase);
        } else {
            this.response.setStatus(responseContext.getStatus());
        }
        if (!responseContext.hasEntity()) {
            return null;
        }
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        block7: {
            try {
                ContainerResponse responseContext;
                int status;
                if (this.configSetStatusOverSendError || this.response.isCommitted() || (status = (responseContext = this.getResponseContext()).getStatus()) < 400 || this.useSetStatusOn404 && status == 404) break block7;
                String reason = responseContext.getStatusInfo().getReasonPhrase();
                try {
                    if (reason == null || reason.isEmpty()) {
                        this.response.sendError(status);
                    } else {
                        this.response.sendError(status, reason);
                    }
                }
                catch (IOException ex) {
                    throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(status, reason != null ? reason : "--"), (Throwable)ex);
                }
            }
            finally {
                this.asyncExt.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable error) {
        block12: {
            try {
                if (this.response.isCommitted()) break block12;
                try {
                    if (this.configSetStatusOverSendError) {
                        this.response.reset();
                        this.response.setStatus(500, "Request failed.");
                    } else {
                        this.response.sendError(500, "Request failed.");
                    }
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.FINER, "Unable to reset failed response.", ex);
                }
                catch (IOException ex) {
                    throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(500, "Request failed."), (Throwable)ex);
                }
                finally {
                    this.asyncExt.complete();
                }
            }
            finally {
                this.rethrow(error);
            }
        }
    }

    public boolean enableResponseBuffering() {
        return true;
    }

    private void rethrow(Throwable error) {
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new ContainerException(error);
    }

    public int getResponseStatus() {
        return this.getResponseContext().getStatus();
    }

    private ContainerResponse getResponseContext() {
        try {
            return (ContainerResponse)this.responseContext.get();
        }
        catch (InterruptedException ex) {
            throw new ContainerException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            throw new ContainerException((Throwable)ex);
        }
    }
}

