/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RemoveFile;
import org.apache.derby.impl.store.raw.data.RemoveFileOperation;
import org.apache.derby.io.StorageFile;

class RFResource
implements FileResource {
    private final BaseDataFileFactory factory;

    RFResource(BaseDataFileFactory baseDataFileFactory) {
        this.factory = baseDataFileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long add(String string, InputStream inputStream) throws StandardException {
        long l;
        block23: {
            OutputStream outputStream = null;
            if (this.factory.isReadOnly()) {
                throw StandardException.newException("XSDFB.S");
            }
            l = this.factory.getNextId();
            StorageFile storageFile = this.getAsFile(string, l);
            if (storageFile.exists()) {
                throw StandardException.newException("XSDF0.S", storageFile);
            }
            ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
            RawTransaction rawTransaction = this.factory.getRawStoreFactory().getXactFactory().findUserTransaction(this.factory.getRawStoreFactory(), contextManager, "UserTransaction");
            rawTransaction.blockBackup(true);
            StorageFile storageFile2 = storageFile.getParentDir();
            StorageFile storageFile3 = storageFile2.getParentDir();
            boolean bl = storageFile3.exists();
            if (!storageFile2.exists()) {
                if (!storageFile2.mkdirs()) {
                    throw StandardException.newException("XSDF3.S", storageFile2);
                }
                storageFile2.limitAccessToOwner();
                if (!bl) {
                    storageFile3.limitAccessToOwner();
                }
            }
            outputStream = storageFile.getOutputStream();
            byte[] byArray = new byte[4096];
            this.factory.writeInProgress();
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                this.factory.writableStorageFactory.sync(outputStream, false);
                Object var15_14 = null;
                this.factory.writeFinished();
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                this.factory.writeFinished();
                throw throwable;
            }
            Object var17_17 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block23;
            }
            catch (IOException iOException) {}
            break block23;
            {
                catch (IOException iOException) {
                    throw StandardException.newException("XSDFF.S", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return l;
    }

    public void removeJarDir(String string) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        RawTransaction rawTransaction = this.factory.getRawStoreFactory().getXactFactory().findUserTransaction(this.factory.getRawStoreFactory(), contextManager, "UserTransaction");
        StorageFile storageFile = this.factory.storageFactory.newStorageFile(string);
        RemoveFile removeFile = new RemoveFile(storageFile);
        rawTransaction.addPostCommitWork(removeFile);
    }

    public void remove(String string, long l) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        RawTransaction rawTransaction = this.factory.getRawStoreFactory().getXactFactory().findUserTransaction(this.factory.getRawStoreFactory(), contextManager, "UserTransaction");
        rawTransaction.blockBackup(true);
        rawTransaction.logAndDo(new RemoveFileOperation(string, l, true));
        RemoveFile removeFile = new RemoveFile(this.getAsFile(string, l));
        rawTransaction.addPostCommitWork(removeFile);
    }

    public long replace(String string, long l, InputStream inputStream) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        this.remove(string, l);
        long l2 = this.add(string, inputStream);
        return l2;
    }

    public StorageFile getAsFile(String string, long l) {
        String string2 = this.factory.getVersionedName(string, l);
        return this.factory.storageFactory.newStorageFile(string2);
    }

    public char getSeparatorChar() {
        return this.factory.storageFactory.getSeparator();
    }
}

