import java.util.*;

public final class Period {
    private final Date start;
    private final Date end;

    /**
     * @param  start - pocztek odcinka czasu
     * @param  end - koniec odcinka czasu, nie moe by wczeniejszy ni start
     * @throws IllegalArgumentException, jeeli start jest wikszy ni end
     * @throws NullPointerException, jeeli start lub end ma warto null.
     */
    public Period(Date start, Date end) {
        if (start.compareTo(end) > 0)
            throw new IllegalArgumentException(
                start + " po " + end);
        this.start = start;
        this.end   = end;
    }


    public Date start() {
        return start;
    }
    public Date end() {
        return end;
    }


    public String toString() {
        return start + " - " + end;
    }

}