import java.util.*;
import java.io.*;

public final class Period implements Serializable {
    private Date start;
    private Date end;

    /**
     * @param  start - pocztek odcinka czasu
     * @param  end - koniec odcinka czasu, nie moe by wczeniejszy ni start
     * @throws IllegalArgumentException jeeli start jest wikszy ni end
     * @throws NullPointerException jeeli start lub end ma warto null.
     */
    public Period(Date start, Date end) {
        this.start = new Date(start.getTime());
        this.end   = new Date(end.getTime());
        if (this.start.compareTo(this.end) > 0)
            throw new IllegalArgumentException(
                          start + " po " + end);
    }

    public Date start () { return new Date(start.getTime()); }

    public Date end ()   { return new Date(end.getTime()); }

    public String toString() { return start + " - " + end; }

//  private void readObject(ObjectInputStream s)
//          throws IOException, ClassNotFoundException {
//      s.defaultReadObject();
//
//      if (start.compareTo(end) > 0)
//          throw new InvalidObjectException(start +" po "+ end);
//  }

//  private void readObject(ObjectInputStream s)
//          throws IOException, ClassNotFoundException {
//      s.defaultReadObject();
//
//      start = new Date(start.getTime());
//      end   = new Date(end.getTime());
//
//      if (start.compareTo(end) > 0)
//          throw new InvalidObjectException(start +" po "+ end);
//  }
}
