// Czy moesz zlokalizowa "wyciek pamici"?
public class Stack {
    private Object[] elements;
    private int size = 0;

    public Stack(int initialCapacity) {
        this.elements = new Object[initialCapacity];
    }

    public void push(Object e) {
        ensureCapacity();
        elements[size++] = e;
    }

    public Object pop() {
        if (size==0)
            throw new EmptyStackException();
        return elements[--size];
    }

    /**
     * Zapewnienie miejsca na co najmniej jeden element, przy dwukrotnym
     * zwikszeniu rozmiaru tablicy za kadym razem, gdy musi by ona powikszona.
     */
    private void ensureCapacity() {
        if (elements.length == size) {
            Object[] oldElements = elements;
            elements = new Object[2 * elements.length + 1];
            System.arraycopy(oldElements, 0, elements, 0, size);
        }
    }
}
