// Program P10.3

import java.io.*;
import java.util.*;
public class WordFrequencyHash {
   static   Scanner in;
   static   PrintWriter out;
   final static int N = 13; //wielko tablicy
   final static int MaxWords = 10;
   final static String Empty = "";
        
   public static void main(String[] args) throws IOException {
      in = new Scanner(new FileReader("wordFreq.in"));
      out = new PrintWriter(new FileWriter("wordFreq.out"));
        
      WordInfo[] wordTable = new WordInfo[N+1];
      for (int h = 1; h <= N; h++) wordTable[h] = new WordInfo();
        
      int first = -1; //wskazuje pierwsze sowo w porzdku alfabetycznym
      int numWords = 0;
        
      in.useDelimiter("[^a-zA-Z󜟿]+");
      while (in.hasNext()) {
         String word = in.next().toLowerCase();
         int loc = search(wordTable, word);
         if (loc > 0) wordTable[loc].freq++;
         else //to nowe sowo
            if (numWords < MaxWords) { //jeli tablica nie jest pena
               first = addToTable(wordTable, word, -loc, first);
               ++numWords;
            }
            else out.printf("Sowo '%s' nie zostao dodane do tablicy\n", word);
      }
      printResults(wordTable, first);
      in.close();
      out.close();
   } //koniec main
        
   public static int search(WordInfo[] table, String key) {
   //funkcja szuka klucza 'key' w tablicy; jeli go znajdzie zwraca jego 
   //pozycj; w przeciwnym razie, jeli sowo musi by wstawione w pozycji
   //loc, funkcja zwraca -loc
      int wordNum = convertToNumber(key);
      int loc = wordNum % N + 1;
      int k = wordNum % (N - 2) + 1;
        
      while (!table[loc].word.equals(Empty) && !table[loc].word.equals(key)) {
         loc = loc + k;
         if (loc > N) loc = loc - N;
      }
      if (table[loc].word.equals(Empty)) return -loc;
      return loc;
   } //koniec search
        
   public static int convertToNumber(String key) {
      int wordNum = 0;
      int w = 3;
      for (int h = 0; h < key.length(); h++) {
         wordNum += key.charAt(h) * w;
         w = w + 2;
      }
      return wordNum;
   } //koniec convertToNumber
        
   public static int addToTable(WordInfo[] table, String key, int loc, int head) {
   //funkcja zapisuje key w table[loc] i docza go w kolejnoci alfabetycznej
      table[loc].word = key;
      table[loc].freq = 1;
      int curr = head;
      int prev = -1;
      while (curr != -1 && key.compareTo(table[curr].word) > 0) {
         prev = curr;
         curr = table[curr].next;
      }
      table[loc].next = curr;
      if (prev == -1) return loc; //nowy pierwszy element
      table[prev].next = loc;
      return head; //pierwszy element nie zosta zmieniony
   } //koniec addToTable
        
   public static void printResults(WordInfo[] table, int head) {
      out.printf("\nSowo        Liczba wystpie\n\n");
      while (head != -1) {
         out.printf("%-15s %2d\n", table[head].word, table[head].freq);
         head = table[head].next;
      }
   } //koniec printResults
        
} //koniec klasy WordFrequencyHash
        
class WordInfo {
   String word = "";
   int freq = 0;
   int next = -1;
} //koniec klasy WordInfo
                