// Program P9.3

import java.io.*;
public class QuicksortTest {
     
   public static void main(String[] args) throws IOException {
      int[] num = {0, 37, 25, 43, 65, 48, 84, 73, 18, 79, 56, 69, 32};
      int n = 12;
      quicksort(num, 1, n);
      for (int h = 1; h <= n; h++) System.out.printf("%d ", num[h]);
      System.out.printf("\n");
   }
     
   public static void quicksort(int[] A, int lo, int hi) {
   //sortuje A[lo] do A[hi] w kolejnoci rosncej
      if (lo < hi) {
         int dp = partition1(A, lo, hi);
         quicksort(A, lo, dp-1);
         quicksort(A, dp+1, hi);
      }
   } //koniec quicksort
     
   public static int partition1(int[] A, int lo, int hi) {
   //dzieli A[lo] do A[hi] uywajc A[lo] jako elementu rozdzielajcego
      int pivot = A[lo];
      int lastSmall = lo;
      for (int j = lo + 1; j <= hi; j++)
         if (A[j] < pivot) {
            ++lastSmall;
            swap(A, lastSmall, j);
         }
      //koniec for
      swap(A, lo, lastSmall);
      return lastSmall;  //zwracamy punkt podziau
   } //koniec partition1
     
   public static void swap(int[] list, int i, int j) {
   //funkcja zamienia elementy list[i] oraz list[j]
      int hold = list[i];
      list[i] = list[j];
      list[j] = hold;
   }
     
} //koniec klasy QuicksortTest
