// Program P8.4

import java.io.*;
import java.util.*;
public class LevelOrderTest {
   public static void main(String[] args) throws IOException {
      
      Scanner in = new Scanner(new FileReader("btree.in"));
      BinaryTree bt = new BinaryTree(in);
      
      System.out.printf("\n\nPrzejcie drzewa metod level-order: ");
      bt.levelOrderTraversal();
      System.out.printf("\n");
      in.close();
   } //koniec main
      
} //koniec klasy LevelOrderTest
      
class NodeData {
   String word;
      
   public NodeData(String w) {
      word = w;
   }
      
   public void visit() {
      System.out.printf("%s ", word);
   }
} //koniec klasy NodeData
      
class TreeNode {
   NodeData data;
   TreeNode left, right, parent;
      
   public TreeNode(NodeData d) {
      data = d;
      left = right = parent = null;
   }
} //koniec klasy TreeNode
      
//Klasa BinaryTree - przedsatwilimy tu jedynie metody uywane w programie
class BinaryTree {
   TreeNode root;
      
   public BinaryTree() {
      root = null;
   }
      
   public BinaryTree(Scanner in) {
      root = buildTree(in);
   }
      
  public static TreeNode buildTree(Scanner in) {
   String str = in.next();
      if (str.equals("@")) return null;
      TreeNode p = new TreeNode(new NodeData(str));
      p.left = buildTree(in);
      p.right = buildTree(in);
      return p;
   } //koniec buildTree
      
   public void levelOrderTraversal() {
      Queue Q = new Queue();
      Q.enqueue(new QueueData(root));
      while (!Q.empty()) {
         QueueData temp = Q.dequeue();
         temp.node.data.visit();
         if (temp.node.left != null) Q.enqueue(new QueueData(temp.node.left));
         if (temp.node.right != null) Q.enqueue(new QueueData(temp.node.right));
      }
   } //koniec levelOrderTraversal
      
} //koniec klasy BinaryTree
      
class QueueData {
   TreeNode node;
      
   public QueueData(TreeNode n) {
      node = n;
   }
} //koniec class QueueData
      
class QNode {
   QueueData data;
   QNode next;
      
   public QNode(QueueData d) {
      data = d;
      next = null;
   }
} //koniec klasy QNode
      
class Queue {
   QNode head = null, tail = null;
      
   public boolean empty() {
      return head == null;
   }
      
   public void enqueue(QueueData nd) {
      QNode p = new QNode(nd);
      if (this.empty()) {
         head = p;
         tail = p;
      }
      else {
         tail.next = p;
         tail = p;
      }
   } //koniec enqueue
      
   public QueueData dequeue() {
      if (this.empty()) {
         System.out.printf("\nPrba usunicia elementu z pustej kolejki\n");
         System.exit(1);
      }
      QueueData hold = head.data;
      head = head.next;
      if (head == null) tail = null;
      return hold;
   } //koniec dequeue
      
} //koniec klasy Queue
              