// Program P6.5

public class BottleCaps {
   static int MaxSim = 20;
   static int MaxLetters = 5;
   public static void main(String[] args) {
      int sim, capsThisSim, totalCaps = 0;
      System.out.printf("\nSymulacja zbierania kapsli\n\n");
      for (sim = 1; sim <= MaxSim; sim++) {
         capsThisSim = doOneSimulation();
         System.out.printf("%6d %13d\n", sim, capsThisSim);
         totalCaps += capsThisSim;
      }
      System.out.printf("\nrednia liczba zebranych kapsli: %d\n", totalCaps/MaxSim);
   } //koniec main
 
   public static int doOneSimulation() {
      boolean[] cap = new boolean[MaxLetters];
      for (int j = 0; j < MaxLetters; j++) cap[j] = false;
      int numCaps = 0;
      while (!mango(cap)) {
         int c = random(1, 20);
         if (c <= 8) cap[0] = true;
         else if (c <= 13) cap[1] = true;
         else if (c <= 16) cap[2] = true;
         else if (c <= 19) cap[3] = true;
         else cap[4] = true;
         numCaps++;
      } //koniec while
      return numCaps;
   } //koniec doOneSimulation
 
   public static boolean mango(boolean[] cap) {
     for (int j = 0; j < MaxLetters; j++)
         if (cap[j] == false) return false;
      return true;
   } //koniec mango
 
   public static int random(int m, int n) {
   //funkcja zwraca liczb losow z zakresu od m do n, wcznie
      return (int) (Math.random() * (n - m + 1)) + m;
   } //koniec random

} //koniec klasy BottleCaps
