//Program P5.3

import java.io.*;
import java.util.*;
public class Maze {
   static int[][]G;           //dostpne dla wszystkich metod
   static int m, n, sr, sc;   //dostpne dla wszystkich metod
   public static void main(String[] args) throws IOException {
      Scanner in = new Scanner(new FileReader("maze.in"));
      PrintWriter out = new PrintWriter(new FileWriter("maze.out"));
      getData(in);
      if (findPath(sr, sc)) printMaze(out);
      else out.printf("\nNie znaleziono wyjcia!\n");
      in.close(); out.close();
   } //koniec main

   public static void getData(Scanner in) {
      m = in.nextInt();   n = in.nextInt();
      G = new int[m+1][n+1];
      sr = in.nextInt();   sc = in.nextInt();
      for (int r = 1; r <= m; r++)
         for (int c = 1; c <= n; c++)
            G[r][c] = in.nextInt();
   } //koniec getData
   
   public static boolean findPath(int r, int c) {
      if (r < 1 || r > m || c < 1 || c > n) return false;
      if (G[r][c] == 1) return false; //ciana
      if (G[r][c] == 2) return false; //miejsce ju zostao sprawdzone
      // else G[r][c] = 0;
      G[r][c] = 2; //oznaczamy ciek
      if (r == 1 || r == m || c == 1 || c == n) return true;
      //znalelimy ciek - puste miejsce na krawdzi labiryntu
   
      if (findPath(r-1, c)) return true;
      if (findPath(r, c+1)) return true;
      if (findPath(r+1, c)) return true;
      if (findPath(r, c-1)) return true;
      G[r][c] = 0; //brak cieki, usuwamy oznaczenie
      return false;
   } //koniec findPath
   
   public static void printMaze(PrintWriter out) {
      int r, c;
      for (r = 1; r <= m; r++) {
         for (c = 1; c <= n; c++)
            if (r == sr && c == sc) out.printf("S");
            else if (G[r][c] == 0) out.printf(" ");
            else if (G[r][c] == 1) out.printf("#");
            else out.printf("x");
         out.printf("\n");
      }
   } //koniec printMaze
   
} //koniec klasy Maze
