//Program P4.7

import java.util.*;
public class QueueTest {
   public static void main(String[] args) {
      Scanner in = new Scanner(System.in);
      Queue Q = new Queue();
      System.out.printf("Wpisz dodatni liczb cakowit: ");
      int n = in.nextInt();
      while (n > 0) {
         Q.enqueue(n % 10);
         n = n / 10;
      }
      System.out.printf("\nCyfry w odwrotnej kolejnoci: ");
      while (!Q.empty())
         System.out.printf("%d", Q.dequeue());
      System.out.printf("\n");
   } //koniec main
    
} //koniec klasy QueueTest

class Queue {
   final static int MaxQ = 100;
   int head = 0, tail = 0;
   int[] QA = new int[MaxQ];
   
   public boolean empty() {
      return head == tail;
   }
   
   public void enqueue(int n) {
      tail = (tail + 1) % MaxQ; //cykliczna inkrementacja pola tail
      if (tail == head) {
         System.out.printf("\nKolejka jest pena!\n");
         System.exit(1);
      }
      QA[tail] = n;
   } //koniec enqueue
   
   public int dequeue() {
      if (this.empty()) {
         System.out.printf("\nPrba usunicia elementu z pustej kolejki!\n");
         System.exit(2);
      }
      head = (head + 1) % MaxQ; //cykliczna inkrementacja pola head 
      return QA[head];
   } //koniec dequeue
   
} //koniec klasy Queue
