//Program P4.6

import java.io.*;
public class EvalExpression {

   public static void main(String[] args) throws IOException {
      char[] post = new char[255];
      int n = readConvert(post);
      printPostfix(post, n);
      System.out.printf("\nWartoci tego wyraenia jest: %d\n", eval(post, n));
   } //koniec main
  
   public static int readConvert(char[] post) throws IOException {
   //funkcja wczytuje wyraenie i wykonuje konwersj na zapis przyrostkowy;
   //zwraca dugoc wyraenie w zapisie przyrostkowym.
      Stack S = new Stack();
      int h = 0;
      char c;
      System.out.printf("Wpiszy wyraenie w zapisie wrostkowym i nacinij Enter\n");
      char token = getToken();
      while (token != '\0') {
         if (Character.isDigit(token)) post[h++] = token;
         else if (token == '(') S.push(new NodeData('('));
         else if (token == ')')
            while ((c = S.pop().getCharData()) != '(') post[h++] = c;
         else {
            while (!S.empty() &&
                   precedence(S.peek().getCharData()) >= precedence(token))
               post[h++] = S.pop().getCharData();
            S.push(new NodeData(token));
         }
         token = getToken();
      }
      while (!S.empty()) post[h++] = S.pop().getCharData();
      return h;
   } //koniec readConvert
   
   public static void printPostfix(char[] post, int n) {
      System.out.printf("\nWyraenie w zapisie przyrostkowym ma posta: \n");
      for (int h = 0; h < n; h++) System.out.printf("%c ", post[h]);
      System.out.printf("\n");
   } //koniec printPostfix
   
   public static char getToken() throws IOException {
      int n;
      while ((n = System.in.read()) == ' ') ; //pomijamy odstpy
      if (n == '\r') return '\0';
      return (char) n;
   } //koniec getToken
   
   public static int precedence(char c) {
   //funkcja zwraca priorytet podanego operatora
      if (c == '(') return 0;
      if (c == '+' || c == '-') return 3;
      if (c == '*' || c == '/') return 5;
      return -99; //bd
   } //koniec precedence
   
   public static int eval(char[] post, int n) {
   //funkcja wylicza i zwraca warto wyraenia w zapisie przyrostkowym
      int a, b, c;
      Stack S = new Stack();
      for (int h = 0; h < n; h++) {
         if (Character.isDigit(post[h]))
            S.push(new NodeData(post[h] - '0'));
         else {
            b = S.pop().getIntData();
            a = S.pop().getIntData();
            if (post[h] == '+') c = a + b;
            else if (post[h] == '-') c = a - b;
            else if (post[h] == '*') c = a * b;
            else c = a / b;
            S.push(new NodeData(c));
         } //koniec if
      } //koniec for
      return S.pop().getIntData();
   } //koniec eval
   
} //koniec class EvalExpression

class NodeData {
   char ch;
   int num;
   
   public NodeData(char c) {
      ch = c;
   }
    
   public NodeData(int n) {
      num = n;
   }
    
   public NodeData(char c, int n) {
      ch = c;
      num = n;
   }
    
   public char getCharData() {return ch;}
    
   public int getIntData() {return num;}
    
   public static NodeData getRogueValue() {
      return new NodeData('$', -999999);   //uytkownik wybierze odpowiedni warto
   }
    
} //koniec class NodeData

class Node {
   NodeData data;         
   Node next;
   public Node(NodeData d) {
      data = d;          
      next = null;
   }
} //koniec class Node
 

class Stack {
   Node top = null;
   public boolean empty() {
      return top == null;
   }
   
   public void push(NodeData nd) {
      Node p =  new Node(nd);
      p.next = top;
      top = p;
   } //koniec push
   
   public NodeData pop() {
      if (this.empty())return NodeData.getRogueValue();
      NodeData hold = top.data;
      top = top.next;
      return hold;
   } //koniec pop
   
   public NodeData peek() {
      if (!this.empty()) return top.data;
      return null;
   } //koniec peek
   
} //koniec class Stack
