//Program P2.4

import java.io.*;
import java.util.*;
public class WordFrequency {
   final static int MaxWords = 50;
   public static void main(String[] args) throws IOException {
      WordInfo[] wordTable = new WordInfo[MaxWords];
      FileReader in = new FileReader("passage.txt");
      PrintWriter out = new PrintWriter(new FileWriter("output.txt"));
      for (int h = 0; h < MaxWords; h++) wordTable[h] = new WordInfo("", 0);
      int numWords = 0;
      String word = getWord(in).toLowerCase();
      while (!word.equals("")) {
         int loc = binarySearch(word, wordTable, 0, numWords-1);
         if (word.compareTo(wordTable[loc].word) == 0) wordTable[loc].incrFreq();
         else //to jest nowe sowo
            if (numWords < MaxWords) { //jeli tablica nie jest pena
               addToList(word, wordTable, loc, numWords-1);
               ++numWords;
            }
            else out.printf("Sowo '%s' nie zostao dodane do tablicy\n", word);
         word = getWord(in).toLowerCase();
      }
      printResults(out, wordTable, numWords);
      in.close();
      out.close();
   } //koniec main

   public static int binarySearch(String key, WordInfo[] list, int lo, int hi) {
   //szukamy acucha okrelonego parametrem key, w zakresie  list[lo] do list[hi]
   //jeli uda si j znale, to zwracamy jego indeks,
   //w przeciwnym przypadku zwracamy indeks miejsca w ktrym acuch naley umieci;
   //kod wywoujcy musi sprawdzi to miejsce by okreli czy acuch zosta znaleziony
      while (lo <= hi) {
         int mid = (lo + hi) / 2;
         int cmp = key.compareToIgnoreCase(list[mid].word);
         if (cmp == 0) return mid;   // wyszukiwanie zakoczone sukcesem
         if (cmp < 0) hi = mid -1;   // key jest 'mniejszy' od list[mid]
         else lo = mid + 1;          // key jest 'wikszy' od list[mid]
      }
      return lo; //acuch key musi zosta wstawiony do komrki o indeksie lo
   } //koniec binarySearch

   public static void addToList(String item, WordInfo[] list, int p, int n) {
   //dodaje acuch w parametrze item na pozycji list[p]; przypisuje freq[p] warto 1
   //przesuwa elementy od list[n] do list[p] o jedn pozycj w prawo
      for (int h = n; h >= p; h--) list[h + 1] = list[h];
      list[p] = new WordInfo(item, 1);
   } //koniec addToList

   public static void printResults(PrintWriter out, WordInfo[] list, int n) {
      out.printf("\nSowa             Licznik\n\n");
      for (int h = 0; h < n; h++)
         out.printf("%-20s %2d\n", list[h].word, list[h].freq);
   } //koniec printResults

   public static String getWord(FileReader in) throws IOException {
   //zwraca nowe sowo odczytane z pliku 
      final int MaxLen = 255;
      int c, n = 0;
      char[] word = new char[MaxLen];
      // przeskakujemy znaki, ktre nie s literami
      while (!Character.isLetter((char) (c = in.read())) && (c != -1)) ;
      //odczytujemy znaki
      if (c == -1) return ""; //nie znaleziono liter
      word[n++] = (char) c;
      while (Character.isLetter(c = in.read()))
         if (n < MaxLen) word[n++] = (char) c;
      return new String(word, 0, n);
   } //koniec getWord
} //koniec klasy WordFrequency


class WordInfo {
   String word;
   int freq = 0;
  WordInfo(String w, int f) {
      word = w;
      freq = f;
   }
  void incrFreq() {
      freq++;
   }
} //koniec klasy WordInfo
