// Program P1.7

import java.io.*;
public class WordFrequency {
   final static int MaxWords = 50;
   public static void main(String[] args) throws IOException {
      String[] wordList = new String[MaxWords];
      int[] frequency = new int[MaxWords];
      FileReader in = new FileReader("passage.txt");
      PrintWriter out = new PrintWriter(new FileWriter("output.txt"));
      for (int h = 0; h < MaxWords; h++) {
         frequency[h] = 0;
         wordList[h] = "";
      }
      int numWords = 0;
      String word = getWord(in).toLowerCase();
      while (!word.equals("")) {
         int loc = binarySearch(word, wordList, 0, numWords-1);
         if (word.compareTo(wordList[loc]) == 0) ++frequency[loc]; //znaleziono sowo
         else //to jest nowe sowo
            if (numWords < MaxWords) { //jeli tablica nie jest pena
               addToList(word, wordList, frequency, loc, numWords-1);
               ++numWords;
            }
            else out.printf("Sowo '%s' nie zostao dodane do tablicy\n", word);
         word = getWord(in).toLowerCase();
      }
      printResults(out, wordList, frequency, numWords);
      in.close();
      out.close();
   } // koniec main
   
   public static int binarySearch(String key, String[] list, int lo, int hi) {
   //szukamy acucha okrelonego parametrem key, w zakresie  list[lo] do list[hi]
   //jeli uda si j znale, to zwracamy jego indeks,
   //w przeciwnym przypadku zwracamy indeks miejsca w ktrym acuch naley umieci;
   //kod wywoujcy musi sprawdzi to miejsce by okreli czy acuch zosta znaleziony
      while (lo <= hi) {
         int mid = (lo + hi) / 2;
         int cmp = key.compareTo(list[mid]);
         if (cmp == 0) return mid;   // wyszukiwanie zakoczone sukcesem
         if (cmp < 0) hi = mid - 1;  // key jest 'mniejszy' od list[mid]
         else lo = mid + 1;          // key jest 'wikszy' od list[mid]
      } 
      return lo; //acuch key musi zosta wstawiony do komrki o indeksie lo
   } //koniec binarySearch

   public static void addToList(String item, String[] list, int[] freq, int p, int n) {
   //dodaje acuch w parametrze item na pozycji list[p]; przypisuje freq[p] warto 1
   //przesuwa elementy od list[n] do list[p] o jedn pozycj w prawo
      for (int h = n; h >= p; h--) {
         list[h + 1] = list[h];
         freq[h + 1] = freq[h];
      }
      list[p] = item;
      freq[p] = 1;
   } //koniec addToList
   
   public static void printResults(PrintWriter out, String[] list, int freq[], int n) {
      out.printf("\nSowa             Licznik\n\n");
      for (int h = 0; h < n; h++)
         out.printf("%-20s %2d\n", list[h], freq[h]);
   } //koniec printResults
   
   public static String getWord(FileReader in) throws IOException {
   //zwraca nowe sowo odczytane z pliku 
      final int MaxLen = 255;
      int c, n = 0;
      char[] word = new char[MaxLen];
      // przeskakujemy znaki, ktre nie s literami
      while (!Character.isLetter((char) (c = in.read())) && (c != -1)) ;
      //odczytujemy znaki
      if (c == -1) return ""; //nie znaleziono liter
      word[n++] = (char) c;
      while (Character.isLetter(c = in.read()))
         if (n < MaxLen) word[n++] = (char) c;
      return new String(word, 0, n);
   } // koniec getWord
} //koniec klasy WordFrequency
