package com.javapowertools.taxcalculator.domain;

import static org.junit.Assert.*;
import org.junit.Test;

public class TaxRateTest {

    private static final double FIRST_TAX_BRACKET_RATE = 0.19;
    private static final double SECOND_TAX_BRACKET_RATE = 0.30;
    private static final double THIRD_TAX_BRACKET_RATE = 0.40;

    @Test
    public void testCalculateTaxBracket1() {
        TaxRate rate = new TaxRate(0, 43405, FIRST_TAX_BRACKET_RATE);
        assertEquals(0.0, rate.calculateTax(0), 0.0);
        assertEquals(10000 * FIRST_TAX_BRACKET_RATE,
                     rate.calculateTax(10000), 0.0);
        assertEquals(43405 * FIRST_TAX_BRACKET_RATE,
                     rate.calculateTax(43405), 0.0);
        assertEquals(43405 * FIRST_TAX_BRACKET_RATE,
                     rate.calculateTax(50000), 0.0);
    }

    @Test
    public void testCalculateTaxBracket2() {
        TaxRate rate = new TaxRate(43405, 85528, SECOND_TAX_BRACKET_RATE);
        assertEquals(0.0, rate.calculateTax(0), 0.0);
        assertEquals(0.0, rate.calculateTax(10000), 0.0);
        assertEquals(0.0, rate.calculateTax(43405), 0);
        assertEquals(2000 * SECOND_TAX_BRACKET_RATE,
                     rate.calculateTax(50000), 0);
        assertEquals(22000 * SECOND_TAX_BRACKET_RATE,
                     rate.calculateTax(85528), 0.0);
        assertEquals(22000 * SECOND_TAX_BRACKET_RATE,
                     rate.calculateTax(90000), 0.0);
    }


    @Test
    public void testCalculateTaxBracket3() {
        TaxRate rate = new TaxRate(85528, 0, THIRD_TAX_BRACKET_RATE);
        assertEquals(0.0, rate.calculateTax(0), 0.0);
        assertEquals(0.0, rate.calculateTax(10000), 0.0);
        assertEquals(0.0, rate.calculateTax(43405), 0);
        assertEquals(0.0, rate.calculateTax(50000), 0);
        assertEquals(0.0, rate.calculateTax(85528), 0.0);
        assertEquals(20000 * THIRD_TAX_BRACKET_RATE,
                     rate.calculateTax(90000), 0.0);
        assertEquals(40000 * THIRD_TAX_BRACKET_RATE,
                     rate.calculateTax(100000), 0.0);
    }

    public void testCalculateTax4() {
        TaxRate rate = new TaxRate(60000, 0, THIRD_TAX_BRACKET_RATE);
        assertEquals(0.0, rate.calculateTax(0), 0.0);
        //assertThat(rate,
    }
    
}
