package com.wakaleo.jpt.selenium;

import org.openqa.selenium.server.SeleniumServer;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleneseTestCase;


public class CatalogSeleniumTest extends SeleneseTestCase {
    
    public void setUp() throws Exception {
        selenium = new DefaultSelenium("taronga",
                SeleniumServer.getDefaultPort(),
                "*firefox",
                "http://taronga:8080");
        selenium.start();
    }
    
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCart() {        
        selenium.open("/jpetstore");
        selenium.click("link=Enter the Store");
        selenium.waitForPageToLoad("30000");
        selenium.click("link=Sign In");
        selenium.waitForPageToLoad("30000");
        selenium.type("username", "j2ee");
        selenium.type("password", "j2ee");
        selenium.click("submit");
        selenium.waitForPageToLoad("30000");
        selenium.click("//area[2]");
        selenium.waitForPageToLoad("30000");
        selenium.click("link=FI-FW-02");
        selenium.waitForPageToLoad("30000");
        selenium.click("link=EST-20");
        selenium.waitForPageToLoad("30000");
        String itemPrice = selenium.getText("//div[@id=\"Catalog\"]//tr[6]/td");
        String itemId = selenium.getText("//div[@id=\"Catalog\"]//tr[2]/td");
        String itemName = selenium.getText("//div[@id=\"Catalog\"]//tr[3]/td//font");
        selenium.click("link=Add to Cart");
        selenium.waitForPageToLoad("30000");       
        verifyEquals("Adult Male Goldfish", selenium.getText("//td[3]"));
        verifyEquals("$5.50", selenium.getText("//td[6]"));
        selenium.click("link=Proceed to Checkout");
        selenium.waitForPageToLoad("30000");
        selenium.click("link=Continue");
        selenium.waitForPageToLoad("30000");
        verifyEquals("999 9999 9999 9999", selenium.getValue("order.creditCard"));
        selenium.select("order.cardType", "label=MasterCard");
        assertTrue(selenium.isVisible("order.cardType"));
        assertTrue(selenium.isEditable("order.cardType"));
        selenium.click("link=Sign Out");
    }
    
}
