/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class InstallTask
extends InstallDeployTaskSupport {
    protected void doExecute() {
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder builder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        Pom pom = this.buildPom(builder, localRepo);
        Artifact artifact = this.createArtifact(pom);
        boolean isPomArtifact = "pom".equals(pom.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata(metadata);
        }
        ArtifactInstaller installer = (ArtifactInstaller)this.lookup(ArtifactInstaller.ROLE);
        try {
            if (!isPomArtifact) {
                installer.install(this.file, artifact, localRepo);
            } else {
                installer.install(pom.getFile(), artifact, localRepo);
            }
        }
        catch (ArtifactInstallationException e) {
            throw new BuildException("Error installing artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
        }
        if (this.attachedArtifacts != null) {
            Iterator iter = this.attachedArtifacts.iterator();
            while (iter.hasNext()) {
                AttachedArtifact attached = (AttachedArtifact)iter.next();
                Artifact attachedArtifact = this.createArtifactFromAttached(attached, artifact);
                try {
                    installer.install(attachedArtifact.getFile(), attachedArtifact, localRepo);
                }
                catch (ArtifactInstallationException e) {
                    throw new BuildException("Error installing attached artifact '" + attachedArtifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

