/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.umlgraph.doclet.ClassInfo;
import org.umlgraph.doclet.OptionProvider;
import org.umlgraph.doclet.Options;
import org.umlgraph.doclet.RelationDirection;
import org.umlgraph.doclet.RelationPattern;
import org.umlgraph.doclet.RelationType;
import org.umlgraph.doclet.StringUtil;
import org.umlgraph.doclet.UmlGraph;
import org.umlgraph.doclet.Version;
import org.umlgraph.doclet.Visibility;

class ClassGraph {
    protected static final char FILE_SEPARATOR = '/';
    public static Map<RelationType, String> associationMap = new HashMap<RelationType, String>();
    protected Map<String, ClassInfo> classnames = new HashMap<String, ClassInfo>();
    protected Set<String> rootClasses;
    protected OptionProvider optionProvider;
    protected PrintWriter w;
    protected ClassDoc collectionClassDoc;
    protected ClassDoc mapClassDoc;
    protected String linePostfix;
    protected String linePrefix;
    protected Doc contextDoc;

    public ClassGraph(RootDoc root, OptionProvider optionProvider, Doc contextDoc) {
        this.optionProvider = optionProvider;
        this.collectionClassDoc = root.classNamed("java.util.Collection");
        this.mapClassDoc = root.classNamed("java.util.Map");
        this.contextDoc = contextDoc;
        this.rootClasses = new HashSet<String>();
        for (ClassDoc classDoc : root.classes()) {
            this.rootClasses.add(classDoc.qualifiedName());
        }
        Options opt = optionProvider.getGlobalOptions();
        if (opt.compact) {
            this.linePrefix = "";
            this.linePostfix = "";
        } else {
            this.linePrefix = "\t";
            this.linePostfix = "\n";
        }
    }

    private String qualifiedName(Options opt, String r) {
        if (!opt.showQualified) {
            int dotpos;
            while ((dotpos = r.lastIndexOf(46)) != -1) {
                int start;
                for (start = dotpos; start > 0 && Character.isJavaIdentifierPart(r.charAt(start - 1)); --start) {
                }
                r = r.substring(0, start) + r.substring(dotpos + 1);
            }
        }
        return r;
    }

    private String escape(String s) {
        Pattern toEscape = Pattern.compile("[&<>]");
        if (toEscape.matcher(s).find()) {
            StringBuffer sb = new StringBuffer(s);
            int i = 0;
            block5: while (i < sb.length()) {
                switch (sb.charAt(i)) {
                    case '&': {
                        sb.replace(i, i + 1, "&amp;");
                        i += "&amp;".length();
                        continue block5;
                    }
                    case '<': {
                        sb.replace(i, i + 1, "&lt;");
                        i += "&lt;".length();
                        continue block5;
                    }
                    case '>': {
                        sb.replace(i, i + 1, "&gt;");
                        i += "&gt;".length();
                        continue block5;
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        return s;
    }

    private String htmlNewline(String s) {
        if (s.indexOf(10) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\n') {
                sb.replace(i, i + 1, "<br/>");
                i += "<br/>".length();
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    private String guillemize(Options opt, String s) {
        StringBuffer r = new StringBuffer(s);
        int i = 0;
        block4: while (i < r.length()) {
            switch (r.charAt(i)) {
                case '<': {
                    r.replace(i, i + 1, opt.guilOpen);
                    i += opt.guilOpen.length();
                    continue block4;
                }
                case '>': {
                    r.replace(i, i + 1, opt.guilClose);
                    i += opt.guilClose.length();
                    continue block4;
                }
            }
            ++i;
        }
        return r.toString();
    }

    private String guilWrap(Options opt, String str) {
        return opt.guilOpen + str + opt.guilClose;
    }

    private String visibility(Options opt, ProgramElementDoc e) {
        if (!opt.showVisibility) {
            return " ";
        }
        if (e.isPrivate()) {
            return "- ";
        }
        if (e.isPublic()) {
            return "+ ";
        }
        if (e.isProtected()) {
            return "# ";
        }
        if (e.isPackagePrivate()) {
            return "~ ";
        }
        return " ";
    }

    private String parameter(Options opt, Parameter[] p) {
        String par = "";
        for (int i = 0; i < p.length; ++i) {
            par = par + p[i].name() + this.typeAnnotation(opt, p[i].type());
            if (i + 1 >= p.length) continue;
            par = par + ", ";
        }
        return par;
    }

    private String type(Options opt, Type t) {
        String type = "";
        type = opt.showQualified ? t.qualifiedTypeName() : t.typeName();
        type = type + this.typeParameters(opt, t.asParameterizedType());
        return type;
    }

    private String typeParameters(Options opt, ParameterizedType t) {
        String tp = "";
        if (t == null) {
            return tp;
        }
        Type[] args = t.typeArguments();
        tp = tp + "&lt;";
        for (int i = 0; i < args.length; ++i) {
            tp = tp + this.type(opt, args[i]);
            if (i == args.length - 1) continue;
            tp = tp + ", ";
        }
        tp = tp + "&gt;";
        return tp;
    }

    private String typeAnnotation(Options opt, Type t) {
        String ta = "";
        if (t.typeName().equals("void")) {
            return ta;
        }
        ta = ta + " : ";
        ta = ta + this.type(opt, t);
        ta = ta + t.dimension();
        return ta;
    }

    private void attributes(Options opt, FieldDoc[] fd) {
        for (FieldDoc f : fd) {
            if (this.hidden((ProgramElementDoc)f)) continue;
            String att = "";
            this.stereotype(opt, (Doc)f, Align.LEFT);
            att = this.visibility(opt, (ProgramElementDoc)f) + f.name();
            if (opt.showType) {
                att = att + this.typeAnnotation(opt, f.type());
            }
            this.tableLine(Align.LEFT, att);
            this.tagvalue(opt, (Doc)f);
        }
    }

    private boolean operations(Options opt, ConstructorDoc[] m) {
        boolean printed = false;
        for (ConstructorDoc cd : m) {
            if (this.hidden((ProgramElementDoc)cd)) continue;
            this.stereotype(opt, (Doc)cd, Align.LEFT);
            String cs = this.visibility(opt, (ProgramElementDoc)cd) + cd.name();
            cs = opt.showType ? cs + "(" + this.parameter(opt, cd.parameters()) + ")" : cs + "()";
            this.tableLine(Align.LEFT, cs);
            printed = true;
            this.tagvalue(opt, (Doc)cd);
        }
        return printed;
    }

    private boolean operations(Options opt, MethodDoc[] m) {
        boolean printed = false;
        for (MethodDoc md : m) {
            if (this.hidden((ProgramElementDoc)md) || md.name().equals("<clinit>") && md.isStatic() && md.isPackagePrivate()) continue;
            this.stereotype(opt, (Doc)md, Align.LEFT);
            String op = this.visibility(opt, (ProgramElementDoc)md) + md.name();
            op = opt.showType ? op + "(" + this.parameter(opt, md.parameters()) + ")" + this.typeAnnotation(opt, md.returnType()) : op + "()";
            this.tableLine(Align.LEFT, op, opt, md.isAbstract() ? Font.ABSTRACT : Font.NORMAL);
            printed = true;
            this.tagvalue(opt, (Doc)md);
        }
        return printed;
    }

    private void nodeProperties(Options opt) {
        this.w.print(", fontname=\"" + opt.nodeFontName + "\"");
        this.w.print(", fontcolor=\"" + opt.nodeFontColor + "\"");
        this.w.print(", fontsize=" + opt.nodeFontSize);
        this.w.print(opt.shape.graphvizAttribute());
        this.w.println("];");
    }

    private void tagvalue(Options opt, Doc c) {
        Tag[] tags = c.tags("tagvalue");
        if (tags.length == 0) {
            return;
        }
        for (Tag tag : tags) {
            String[] t = StringUtil.tokenize(tag.text());
            if (t.length != 2) {
                System.err.println("@tagvalue expects two fields: " + tag.text());
                continue;
            }
            this.tableLine(Align.RIGHT, "{" + t[0] + " = " + t[1] + "}", opt, Font.TAG);
        }
    }

    private void stereotype(Options opt, Doc c, Align align) {
        for (Tag tag : c.tags("stereotype")) {
            String[] t = StringUtil.tokenize(tag.text());
            if (t.length != 1) {
                System.err.println("@stereotype expects one field: " + tag.text());
                continue;
            }
            this.tableLine(align, this.guilWrap(opt, t[0]));
        }
    }

    private boolean hidden(ProgramElementDoc c) {
        Tag[] tags = c.tags("hidden");
        if (tags.length > 0) {
            return true;
        }
        tags = c.tags("view");
        if (tags.length > 0) {
            return true;
        }
        Options opt = c instanceof ClassDoc ? this.optionProvider.getOptionsFor((ClassDoc)c) : this.optionProvider.getOptionsFor(c.containingClass());
        return opt.matchesHideExpression(c.toString());
    }

    protected ClassInfo getClassInfo(String className) {
        return this.classnames.get(this.removeTemplate(className));
    }

    private ClassInfo newClassInfo(String className, boolean printed, boolean hidden) {
        ClassInfo ci = new ClassInfo(printed, hidden);
        this.classnames.put(this.removeTemplate(className), ci);
        return ci;
    }

    private boolean hidden(String s) {
        ClassInfo ci = this.getClassInfo(s);
        Options opt = this.optionProvider.getOptionsFor(s);
        if (ci != null) {
            return ci.hidden || opt.matchesHideExpression(s);
        }
        return opt.matchesHideExpression(s);
    }

    public String printClass(ClassDoc c, boolean rootClass) {
        boolean toPrint;
        Options opt = this.optionProvider.getOptionsFor(c);
        String className = c.toString();
        ClassInfo ci = this.getClassInfo(className);
        if (ci != null) {
            toPrint = !ci.nodePrinted;
        } else {
            toPrint = true;
            ci = this.newClassInfo(className, true, this.hidden((ProgramElementDoc)c));
        }
        if (toPrint && !this.hidden((ProgramElementDoc)c) && (!c.isEnum() || opt.showEnumerations)) {
            boolean showMembers;
            String r = className;
            this.w.println("\t// " + r);
            this.w.print("\t" + ci.name + " [label=");
            this.externalTableStart(opt, c.qualifiedName(), this.classToUrl(c, rootClass));
            this.innerTableStart();
            if (c.isInterface()) {
                this.tableLine(Align.CENTER, this.guilWrap(opt, "interface"));
            }
            if (c.isEnum()) {
                this.tableLine(Align.CENTER, this.guilWrap(opt, "enumeration"));
            }
            this.stereotype(opt, (Doc)c, Align.CENTER);
            Font font = c.isAbstract() && !c.isInterface() ? Font.CLASS_ABSTRACT : Font.CLASS;
            String qualifiedName = this.qualifiedName(opt, r);
            int startTemplate = qualifiedName.indexOf(60);
            int idx = 0;
            idx = startTemplate < 0 ? qualifiedName.lastIndexOf(46) : qualifiedName.lastIndexOf(46, startTemplate);
            if (opt.showComment) {
                this.tableLine(Align.LEFT, this.htmlNewline(this.escape(c.commentText())), opt, Font.CLASS);
            } else if (opt.postfixPackage && idx > 0 && idx < qualifiedName.length() - 1) {
                String packageName = qualifiedName.substring(0, idx);
                String cn = className.substring(idx + 1);
                this.tableLine(Align.CENTER, this.escape(cn), opt, font);
                this.tableLine(Align.CENTER, packageName, opt, Font.PACKAGE);
            } else {
                this.tableLine(Align.CENTER, this.escape(qualifiedName), opt, font);
            }
            this.tagvalue(opt, (Doc)c);
            this.innerTableEnd();
            boolean bl = showMembers = opt.showAttributes && c.fields().length > 0 || c.isEnum() && opt.showEnumConstants && c.enumConstants().length > 0 || opt.showOperations && c.methods().length > 0 || opt.showConstructors && c.constructors().length > 0;
            if (showMembers) {
                if (opt.showAttributes) {
                    this.innerTableStart();
                    FieldDoc[] fields = c.fields();
                    if (fields.length == 0) {
                        this.tableLine(Align.LEFT, "");
                    } else {
                        this.attributes(opt, c.fields());
                    }
                    this.innerTableEnd();
                } else if (!c.isEnum() && (opt.showConstructors || opt.showOperations)) {
                    this.innerTableStart();
                    this.tableLine(Align.LEFT, "");
                    this.innerTableEnd();
                }
                if (c.isEnum() && opt.showEnumConstants) {
                    this.innerTableStart();
                    FieldDoc[] ecs = c.enumConstants();
                    if (ecs.length == 0) {
                        this.tableLine(Align.LEFT, "");
                    } else {
                        for (Tag tag : c.enumConstants()) {
                            this.tableLine(Align.LEFT, tag.name());
                        }
                    }
                    this.innerTableEnd();
                }
                if (!c.isEnum() && (opt.showConstructors || opt.showOperations)) {
                    this.innerTableStart();
                    boolean printedLines = false;
                    if (opt.showConstructors) {
                        printedLines |= this.operations(opt, c.constructors());
                    }
                    if (opt.showOperations) {
                        printedLines |= this.operations(opt, c.methods());
                    }
                    if (!printedLines) {
                        this.tableLine(Align.LEFT, "");
                    }
                    this.innerTableEnd();
                }
            }
            this.externalTableEnd();
            this.nodeProperties(opt);
            int ni = 0;
            for (Tag tag : c.tags("note")) {
                String noteName = "n" + ni + "c" + ci.name;
                this.w.print("\t// Note annotation\n");
                this.w.print("\t" + noteName + " [label=");
                this.externalTableStart(UmlGraph.getCommentOptions(), c.qualifiedName(), this.classToUrl(c, rootClass));
                this.innerTableStart();
                this.tableLine(Align.LEFT, this.htmlNewline(this.escape(tag.text())), UmlGraph.getCommentOptions(), Font.CLASS);
                this.innerTableEnd();
                this.externalTableEnd();
                this.nodeProperties(UmlGraph.getCommentOptions());
                this.w.print("\t" + noteName + " -> " + this.relationNode(c) + "[arrowhead=none];\n");
                ++ni;
            }
            ci.nodePrinted = true;
        }
        return ci.name;
    }

    private String getNodeName(ClassDoc c) {
        String className = c.toString();
        ClassInfo ci = this.getClassInfo(className);
        if (ci == null) {
            ci = this.newClassInfo(className, false, this.hidden((ProgramElementDoc)c));
        }
        return ci.name;
    }

    private String getNodeName(String c) {
        ClassInfo ci = this.getClassInfo(c);
        if (ci == null) {
            ci = this.newClassInfo(c, false, false);
        }
        return ci.name;
    }

    private void allRelation(Options opt, RelationType rt, ClassDoc from) {
        String tagname = rt.toString().toLowerCase();
        for (Tag tag : from.tags(tagname)) {
            String[] t = StringUtil.tokenize(tag.text());
            if (t.length != 4) {
                System.err.println("Error in " + from + "\n" + tagname + " expects four fields (l-src label l-dst target): " + tag.text());
                return;
            }
            ClassDoc to = from.findClass(t[3]);
            if (to != null) {
                if (this.hidden((ProgramElementDoc)to)) continue;
                this.relation(opt, rt, from, to, t[0], t[1], t[2]);
                continue;
            }
            if (this.hidden(t[3])) continue;
            this.relation(opt, rt, from, from.toString(), to, t[3], t[0], t[1], t[2]);
        }
    }

    private void relation(Options opt, RelationType rt, ClassDoc from, String fromName, ClassDoc to, String toName, String tailLabel, String label, String headLabel) {
        String edgetype = associationMap.get((Object)rt);
        this.w.println("\t// " + fromName + " " + rt.toString() + " " + toName);
        this.w.println("\t" + this.relationNode(from, fromName) + " -> " + this.relationNode(to, toName) + " [" + "taillabel=\"" + tailLabel + "\", " + "label=\"" + this.guillemize(opt, label) + "\", " + "headlabel=\"" + headLabel + "\", " + "fontname=\"" + opt.edgeFontName + "\", " + "fontcolor=\"" + opt.edgeFontColor + "\", " + "fontsize=" + opt.edgeFontSize + ", " + "color=\"" + opt.edgeColor + "\", " + edgetype + "];");
        RelationDirection d = RelationDirection.BOTH;
        if (rt == RelationType.NAVASSOC || rt == RelationType.DEPEND) {
            d = RelationDirection.OUT;
        }
        this.getClassInfo(fromName).addRelation(toName, rt, d);
        this.getClassInfo(toName).addRelation(fromName, rt, d.inverse());
    }

    private void relation(Options opt, RelationType rt, ClassDoc from, ClassDoc to, String tailLabel, String label, String headLabel) {
        this.relation(opt, rt, from, from.toString(), to, to.toString(), tailLabel, label, headLabel);
    }

    private String relationNode(ClassDoc c) {
        Options opt = this.optionProvider.getOptionsFor(c);
        String name = this.getNodeName(c);
        return name + opt.shape.landingPort();
    }

    private String relationNode(ClassDoc c, String cName) {
        Options opt = c == null ? this.optionProvider.getOptionsFor(cName) : this.optionProvider.getOptionsFor(c);
        String name = this.getNodeName(cName);
        return name + opt.shape.landingPort();
    }

    public void printRelations(ClassDoc c) {
        Options opt = this.optionProvider.getOptionsFor(c);
        if (this.hidden((ProgramElementDoc)c) || c.name().equals("")) {
            return;
        }
        String className = c.toString();
        Type s = c.superclassType();
        if (!(s == null || s.toString().equals("java.lang.Object") || c.isEnum() || this.hidden((ProgramElementDoc)s.asClassDoc()))) {
            ClassDoc sc = s.asClassDoc();
            this.w.println("\t//" + c + " extends " + s + "\n" + "\t" + this.relationNode(sc) + " -> " + this.relationNode(c) + " [dir=back,arrowtail=empty];");
            this.getClassInfo(className).addRelation(sc.toString(), RelationType.EXTENDS, RelationDirection.OUT);
            this.getClassInfo(sc.toString()).addRelation(className, RelationType.EXTENDS, RelationDirection.IN);
        }
        for (Tag tag : c.tags("extends")) {
            if (this.hidden(tag.text())) continue;
            ClassDoc from = c.findClass(tag.text());
            this.w.println("\t//" + c + " extends " + tag.text() + "\n" + "\t" + this.relationNode(from, tag.text()) + " -> " + this.relationNode(c) + " [dir=back,arrowtail=empty];");
            this.getClassInfo(className).addRelation(tag.text(), RelationType.EXTENDS, RelationDirection.OUT);
            this.getClassInfo(tag.text()).addRelation(className, RelationType.EXTENDS, RelationDirection.IN);
        }
        for (Tag tag : c.interfaceTypes()) {
            ClassDoc ic = tag.asClassDoc();
            if (this.hidden((ProgramElementDoc)ic)) continue;
            this.w.println("\t//" + c + " implements " + ic + "\n\t" + this.relationNode(ic) + " -> " + this.relationNode(c) + " [dir=back,arrowtail=empty,style=dashed];");
            this.getClassInfo(className).addRelation(ic.toString(), RelationType.IMPLEMENTS, RelationDirection.OUT);
            this.getClassInfo(ic.toString()).addRelation(className, RelationType.IMPLEMENTS, RelationDirection.IN);
        }
        this.allRelation(opt, RelationType.ASSOC, c);
        this.allRelation(opt, RelationType.NAVASSOC, c);
        this.allRelation(opt, RelationType.HAS, c);
        this.allRelation(opt, RelationType.COMPOSED, c);
        this.allRelation(opt, RelationType.DEPEND, c);
    }

    public void printExtraClasses(RootDoc root) {
        HashSet<String> names = new HashSet<String>(this.classnames.keySet());
        for (String className : names) {
            ClassInfo info = this.getClassInfo(className);
            if (info.nodePrinted) continue;
            ClassDoc c = root.classNamed(className);
            if (c != null) {
                this.printClass(c, false);
                continue;
            }
            Options opt = this.optionProvider.getOptionsFor(className);
            if (opt.matchesHideExpression(className)) continue;
            this.w.println("\t// " + className);
            this.w.print("\t" + info.name + "[label=");
            this.externalTableStart(opt, className, this.classToUrl(className));
            this.innerTableStart();
            int idx = className.lastIndexOf(".");
            if (opt.postfixPackage && idx > 0 && idx < className.length() - 1) {
                String packageName = className.substring(0, idx);
                String cn = className.substring(idx + 1);
                this.tableLine(Align.CENTER, this.escape(cn), opt, Font.CLASS);
                this.tableLine(Align.CENTER, packageName, opt, Font.PACKAGE);
            } else {
                this.tableLine(Align.CENTER, this.escape(className), opt, Font.CLASS);
            }
            this.innerTableEnd();
            this.externalTableEnd();
            this.nodeProperties(opt);
        }
    }

    public void printInferredRelations(ClassDoc[] classes) {
        for (ClassDoc c : classes) {
            this.printInferredRelations(c);
        }
    }

    public void printInferredRelations(ClassDoc c) {
        Options opt = this.optionProvider.getOptionsFor(c);
        if (this.hidden((ProgramElementDoc)c)) {
            return;
        }
        for (FieldDoc field : c.fields(false)) {
            FieldRelationInfo fri;
            if (field.isStatic() || (fri = this.getFieldRelationInfo(field)) == null || this.hidden((ProgramElementDoc)fri.cd)) continue;
            String destAdornment = fri.multiple ? "*" : "";
            this.relation(opt, opt.inferRelationshipType, c, fri.cd, "", "", destAdornment);
        }
    }

    public void printInferredDependencies(ClassDoc[] classes) {
        for (ClassDoc c : classes) {
            this.printInferredDependencies(c);
        }
    }

    public void printInferredDependencies(ClassDoc c) {
        Options opt = this.optionProvider.getOptionsFor(c);
        String sourceName = c.toString();
        if (this.hidden((ProgramElementDoc)c)) {
            return;
        }
        HashSet<Object> types = new HashSet<Object>();
        for (MethodDoc methodDoc : this.filterByVisibility((ProgramElementDoc[])c.methods(false), opt.inferDependencyVisibility)) {
            types.add(methodDoc.returnType());
            for (Parameter parameter : methodDoc.parameters()) {
                types.add(parameter.type());
            }
        }
        if (!opt.inferRelationships) {
            for (FieldDoc fieldDoc : this.filterByVisibility((ProgramElementDoc[])c.fields(false), opt.inferDependencyVisibility)) {
                types.add(fieldDoc.type());
            }
        }
        if (c.asParameterizedType() != null) {
            ParameterizedType pt = c.asParameterizedType();
            types.addAll(Arrays.asList(pt.typeArguments()));
        }
        for (TypeVariable tv : c.typeParameters()) {
            if (tv.bounds().length <= 0) continue;
            types.addAll(Arrays.asList(tv.bounds()));
        }
        if (opt.useImports) {
            types.addAll(Arrays.asList(c.importedClasses()));
        }
        for (Type type : types) {
            RelationPattern rp;
            ClassDoc fc;
            if (type.isPrimitive() || type instanceof WildcardType || type instanceof TypeVariable || c.toString().equals(type.asClassDoc().toString()) || this.hidden((ProgramElementDoc)(fc = type.asClassDoc())) || !opt.inferDepInPackage && c.containingPackage().equals(fc.containingPackage()) || (rp = this.getClassInfo(sourceName).getRelation(fc.toString())) != null && !rp.matchesOne(new RelationPattern(RelationDirection.OUT))) continue;
            this.relation(opt, RelationType.DEPEND, c, fc, "", "", "");
        }
    }

    private <T extends ProgramElementDoc> List<T> filterByVisibility(T[] docs, Visibility visibility) {
        if (visibility == Visibility.PRIVATE) {
            return Arrays.asList(docs);
        }
        ArrayList<T> filtered = new ArrayList<T>();
        for (T doc : docs) {
            if (Visibility.get(doc).compareTo(visibility) <= 0) continue;
            filtered.add(doc);
        }
        return filtered;
    }

    private FieldRelationInfo getFieldRelationInfo(FieldDoc field) {
        Type type = field.type();
        if (type.isPrimitive() || type instanceof WildcardType || type instanceof TypeVariable) {
            return null;
        }
        if (type.dimension().endsWith("[]")) {
            return new FieldRelationInfo(type.asClassDoc(), true);
        }
        Options opt = this.optionProvider.getOptionsFor(type.asClassDoc());
        if (opt.matchesCollPackageExpression(type.qualifiedTypeName())) {
            Type[] argTypes = this.getInterfaceTypeArguments(this.collectionClassDoc, type);
            if (argTypes != null && argTypes.length == 1 && !argTypes[0].isPrimitive()) {
                return new FieldRelationInfo(argTypes[0].asClassDoc(), true);
            }
            argTypes = this.getInterfaceTypeArguments(this.mapClassDoc, type);
            if (argTypes != null && argTypes.length == 2 && !argTypes[1].isPrimitive()) {
                return new FieldRelationInfo(argTypes[1].asClassDoc(), true);
            }
        }
        return new FieldRelationInfo(type.asClassDoc(), false);
    }

    private Type[] getInterfaceTypeArguments(ClassDoc iface, Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (iface.equals(t.asClassDoc())) {
                return pt.typeArguments();
            }
            for (Type pti : pt.interfaceTypes()) {
                Type[] result = this.getInterfaceTypeArguments(iface, pti);
                if (result == null) continue;
                return result;
            }
            if (pt.superclassType() != null) {
                return this.getInterfaceTypeArguments(iface, pt.superclassType());
            }
        } else if (t instanceof ClassDoc) {
            ClassDoc cd = (ClassDoc)t;
            for (Type pti : cd.interfaceTypes()) {
                Type[] result = this.getInterfaceTypeArguments(iface, pti);
                if (result == null) continue;
                return result;
            }
            if (cd.superclassType() != null) {
                return this.getInterfaceTypeArguments(iface, cd.superclassType());
            }
        }
        return null;
    }

    private String removeTemplate(String name) {
        int openIdx = name.indexOf(60);
        if (openIdx == -1) {
            return name;
        }
        return name.substring(0, openIdx);
    }

    public String classToUrl(ClassDoc cd, boolean rootClass) {
        if (this.contextDoc != null && rootClass) {
            String packageName = null;
            if (this.contextDoc instanceof ClassDoc) {
                packageName = ((ClassDoc)this.contextDoc).containingPackage().name();
            } else if (this.contextDoc instanceof PackageDoc) {
                packageName = ((PackageDoc)this.contextDoc).name();
            } else {
                return this.classToUrl(cd.qualifiedName());
            }
            return ClassGraph.buildRelativePath(packageName, cd.containingPackage().name()) + cd.name() + ".html";
        }
        return this.classToUrl(cd.qualifiedName());
    }

    protected static String buildRelativePath(String contextPackageName, String classPackageName) {
        int j;
        int i;
        String[] contextClassPath = contextPackageName.split("\\.");
        String[] currClassPath = classPackageName.split("\\.");
        for (i = 0; i < contextClassPath.length && i < currClassPath.length && contextClassPath[i].equals(currClassPath[i]); ++i) {
        }
        StringBuffer buf = new StringBuffer();
        if (i == contextClassPath.length) {
            buf.append(".").append('/');
        } else {
            for (j = i; j < contextClassPath.length; ++j) {
                buf.append("..").append('/');
            }
        }
        for (j = i; j < currClassPath.length; ++j) {
            buf.append(currClassPath[j]).append('/');
        }
        return buf.toString();
    }

    public String classToUrl(String className) {
        String docRoot = this.mapApiDocRoot(className);
        if (docRoot != null) {
            StringBuffer buf = new StringBuffer(docRoot);
            buf.append(className.replace('.', '/'));
            buf.append(".html");
            return buf.toString();
        }
        return null;
    }

    private String mapApiDocRoot(String className) {
        String root = null;
        if (this.rootClasses.contains(className)) {
            root = this.optionProvider.getGlobalOptions().apiDocRoot;
        } else {
            Options globalOptions = this.optionProvider.getGlobalOptions();
            root = globalOptions.getApiDocRoot(className);
        }
        return root;
    }

    public void prologue() throws IOException {
        Options opt = this.optionProvider.getGlobalOptions();
        OutputStream os = null;
        if (opt.outputFileName.equals("-")) {
            os = System.out;
        } else {
            File file = null;
            file = opt.outputDirectory != null ? new File(opt.outputDirectory, opt.outputFileName) : new File(opt.outputFileName);
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            os = new FileOutputStream(file);
        }
        this.w = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), opt.outputEncoding));
        this.w.println("#!/usr/local/bin/dot\n#\n# Class diagram \n# Generated by UmlGraph version " + Version.VERSION + " (http://www.spinellis.gr/sw/umlgraph)\n" + "#\n\n" + "digraph G {\n" + "\tedge [fontname=\"" + opt.edgeFontName + "\",fontsize=10,labelfontname=\"" + opt.edgeFontName + "\",labelfontsize=10];\n" + "\tnode [fontname=\"" + opt.nodeFontName + "\",fontsize=10,shape=plaintext];");
        if (opt.horizontal) {
            this.w.println("\trankdir=LR;\n\tranksep=1;");
        }
        if (opt.bgColor != null) {
            this.w.println("\tbgcolor=\"" + opt.bgColor + "\";\n");
        }
    }

    public void epilogue() {
        this.w.println("}\n");
        this.w.flush();
        this.w.close();
    }

    private void externalTableStart(Options opt, String name, String url) {
        String bgcolor = "";
        if (opt.nodeFillColor != null) {
            bgcolor = " bgcolor=\"" + opt.nodeFillColor + "\"";
        }
        String href = "";
        if (url != null) {
            href = " href=\"" + url + "\"";
        }
        this.w.print("<<table border=\"" + opt.shape.border() + "\" cellborder=\"" + opt.shape.cellBorder() + "\" cellspacing=\"0\" " + "cellpadding=\"2\" port=\"p\"" + bgcolor + href + ">" + this.linePostfix);
    }

    private void externalTableEnd() {
        this.w.print(this.linePrefix + this.linePrefix + "</table>>");
    }

    private void innerTableStart() {
        this.w.print(this.linePrefix + this.linePrefix + "<tr><td><table border=\"0\" cellspacing=\"0\" " + "cellpadding=\"1\">" + this.linePostfix);
    }

    private void innerTableEnd() {
        this.w.print(this.linePrefix + this.linePrefix + "</table></td></tr>" + this.linePostfix);
    }

    private void tableLine(Align align, String text) {
        this.tableLine(align, text, null, Font.NORMAL);
    }

    private void tableLine(Align align, String text, Options opt, Font font) {
        String alignText;
        String close = "</td></tr>";
        String prefix = this.linePrefix + this.linePrefix + this.linePrefix;
        if (align == Align.CENTER) {
            alignText = "center";
        } else if (align == Align.LEFT) {
            alignText = "left";
        } else if (align == Align.RIGHT) {
            alignText = "right";
        } else {
            throw new RuntimeException("Unknown alignement type " + (Object)((Object)align));
        }
        text = this.fontWrap(" " + text + " ", opt, font);
        String open = "<tr><td align=\"" + alignText + "\" balign=\"" + alignText + "\">";
        this.w.print(open + text + close + this.linePostfix);
    }

    private String fontWrap(String text, Options opt, Font font) {
        if (font == Font.ABSTRACT) {
            return this.fontWrap(text, opt.nodeFontAbstractName, opt.nodeFontSize);
        }
        if (font == Font.CLASS) {
            return this.fontWrap(text, opt.nodeFontClassName, opt.nodeFontClassSize);
        }
        if (font == Font.CLASS_ABSTRACT) {
            String name = opt.nodeFontClassAbstractName == null ? opt.nodeFontAbstractName : opt.nodeFontClassAbstractName;
            return this.fontWrap(text, name, opt.nodeFontClassSize);
        }
        if (font == Font.PACKAGE) {
            return this.fontWrap(text, opt.nodeFontPackageName, opt.nodeFontPackageSize);
        }
        if (font == Font.TAG) {
            return this.fontWrap(text, opt.nodeFontTagName, opt.nodeFontTagSize);
        }
        return text;
    }

    private String fontWrap(String text, String fontName, double fontSize) {
        if (fontName == null && fontSize == -1.0) {
            return text;
        }
        if (fontName == null) {
            return "<font point-size=\"" + fontSize + "\">" + text + "</font>";
        }
        if (fontSize <= 0.0) {
            return "<font face=\"" + fontName + "\">" + text + "</font>";
        }
        return "<font face=\"" + fontName + "\" point-size=\"" + fontSize + "\">" + text + "</font>";
    }

    static {
        associationMap.put(RelationType.ASSOC, "arrowhead=none");
        associationMap.put(RelationType.NAVASSOC, "arrowhead=open");
        associationMap.put(RelationType.HAS, "arrowhead=none, arrowtail=ediamond");
        associationMap.put(RelationType.COMPOSED, "arrowhead=none, arrowtail=diamond");
        associationMap.put(RelationType.DEPEND, "arrowhead=open, style=dashed");
    }

    private static class FieldRelationInfo {
        ClassDoc cd;
        boolean multiple;

        public FieldRelationInfo(ClassDoc cd, boolean multiple) {
            this.cd = cd;
            this.multiple = multiple;
        }
    }

    static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }

    static enum Font {
        NORMAL,
        ABSTRACT,
        CLASS,
        CLASS_ABSTRACT,
        TAG,
        PACKAGE;

    }
}

