/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.objectlab.qalab.interfaces.QALabExporter;
import net.objectlab.qalab.m2.util.Maven2TaskLogger;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.parser.StatMerger;
import net.objectlab.qalab.util.TaskLogger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.InputSource;

public class BuildStatMergeMojo
extends AbstractMojo {
    private File inputFile = null;
    private File outputFile = null;
    private boolean quiet = false;
    private boolean dateOnly = true;
    private String srcDir;
    private String handler;
    private String mergerTimeStamp;
    private String exporterClassName = "net.objectlab.qalab.exporter.QALabXMLExporter";
    private File propertiesFile;
    private Properties theProperties = null;

    public final void execute() throws MojoExecutionException {
        this.theProperties = this.createOverridingProperties();
        this.getLog().info((CharSequence)"Starting QALab Merge");
        if (!this.validate()) {
            return;
        }
        if (!this.quiet) {
            this.getLog().info((CharSequence)"QALab Merge:");
            this.getLog().info((CharSequence)("inputFile='" + this.getInputFile().getPath()));
            this.getLog().info((CharSequence)("outputFile='" + this.outputFile.getPath()));
            this.getLog().info((CharSequence)("srcDir='" + this.srcDir + "', mergerTimeStamp=" + this.mergerTimeStamp));
            String proppath = null;
            if (this.propertiesFile != null) {
                proppath = this.propertiesFile.getPath();
            }
            this.getLog().info((CharSequence)("quiet='" + this.quiet + "', propertiesFile='" + proppath + "'."));
            Iterator<Map.Entry<Object, Object>> it = this.theProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = entry.getKey().toString();
                if (key.indexOf("qalab") < 0) continue;
                this.getLog().info((CharSequence)(key + " = '" + entry.getValue() + "'"));
            }
        }
        this.mergeFiles();
    }

    private void mergeFiles() throws MojoExecutionException {
        try {
            Maven2TaskLogger logger = new Maven2TaskLogger((Mojo)this);
            QALabExporter exporter = (QALabExporter)Class.forName(this.getExporterClassName()).newInstance();
            this.getTheProperties().setProperty("qalab.merge.output.file", this.getOutputFile().getAbsolutePath());
            exporter.setQuiet(this.isQuiet());
            exporter.setTaskLogger((TaskLogger)logger);
            StatMerger merger = (StatMerger)Class.forName(this.getHandler()).newInstance();
            merger.setQuiet(this.isQuiet());
            merger.setSrcDir(this.getSrcDir());
            merger.setTaskLogger((TaskLogger)logger);
            merger.setMergerTimeStamp(this.getMergerTimeStamp(), this.dateOnly);
            this.getTheProperties().setProperty("qalab.merge.output.timestamp", merger.getMergerTimeStamp());
            this.getTheProperties().setProperty("qalab.merge.type", merger.getType());
            exporter.configure(this.getTheProperties());
            merger.mergeStats(new InputSource(new FileInputStream(this.getInputFile())), exporter);
            this.getLog().info((CharSequence)("Files: " + merger.getFileCount() + " Violations:" + merger.getTotalStatistics()));
            exporter.save();
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException(e.toString());
        }
    }

    private boolean validate() throws MojoExecutionException {
        try {
            Utils.checkFile(this.getInputFile(), "inputFile");
            return true;
        }
        catch (IOException ioex) {
            this.getLog().warn((CharSequence)("\n\nQALab ==> The file " + this.getInputFile().getPath() + " cannot be accessed. SKIPPING....\n\n"));
            return false;
        }
    }

    private Properties createOverridingProperties() throws MojoExecutionException {
        Properties result = new Properties();
        if (this.propertiesFile != null && this.propertiesFile.canRead() && this.propertiesFile.isFile()) {
            FileInputStream inStream = null;
            if (!this.quiet) {
                this.getLog().debug((CharSequence)("loading " + this.propertiesFile));
            }
            try {
                inStream = new FileInputStream(this.propertiesFile);
                result.load(inStream);
            }
            catch (FileNotFoundException fnfex) {
                throw new MojoExecutionException("Could not find Properties file '" + this.propertiesFile + "'", (Exception)fnfex);
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Error loading Properties file '" + this.propertiesFile + "'", (Exception)ioex);
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException ioex) {
                    throw new MojoExecutionException("Error closing Properties file '" + this.propertiesFile + "'", (Exception)ioex);
                }
            }
        }
        Map projectContext = this.getPluginContext();
        Iterator it = projectContext.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String value = String.valueOf(entry.getValue());
            if (entry.getKey().toString().indexOf("qalab") >= 0) {
                this.getLog().info((CharSequence)("Adding " + entry.getKey() + " / " + value));
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public String getExporterClassName() {
        return this.exporterClassName;
    }

    public void setExporterClassName(String exporterClassName) {
        this.exporterClassName = exporterClassName;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public String getMergerTimeStamp() {
        return this.mergerTimeStamp;
    }

    public void setMergerTimeStamp(String mergerTimeStamp) {
        this.mergerTimeStamp = mergerTimeStamp;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    public Properties getTheProperties() {
        return this.theProperties;
    }

    public void setTheProperties(Properties theProperties) {
        this.theProperties = theProperties;
    }
}

